/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.qubership.itool.modules.graph.GraphClassifier;
import org.qubership.itool.modules.graph.GraphClassifierBuilder;
import org.qubership.itool.modules.graph.GraphClassifierImpl;

public class GraphClassifierBuilderImpl
implements GraphClassifierBuilder {
    private String id;
    private boolean withReport = true;
    private List<String> departmentIds = new ArrayList<String>();
    private List<String> domainIds = new ArrayList<String>();
    private List<String> releaseVersionIds = new ArrayList<String>();
    private List<String> applicationVersionIds = new ArrayList<String>();

    @Override
    public GraphClassifierBuilder setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public GraphClassifierBuilder setWithReport(boolean withReport) {
        this.withReport = withReport;
        return this;
    }

    @Override
    public GraphClassifierBuilder setDepartmentIds(List<String> departmentIds) {
        this.departmentIds = departmentIds;
        return this;
    }

    @Override
    public GraphClassifierBuilder setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
        return this;
    }

    @Override
    public GraphClassifierBuilder setReleaseVersionIds(List<String> releaseVersionIds) {
        this.releaseVersionIds = releaseVersionIds;
        return this;
    }

    @Override
    public GraphClassifierBuilder setApplicationVersionIds(List<String> applicationVersionIds) {
        this.applicationVersionIds = applicationVersionIds;
        return this;
    }

    @Override
    public GraphClassifierBuilder addDepartment(String departmentId) {
        this.departmentIds.add(departmentId);
        return this;
    }

    @Override
    public GraphClassifierBuilder addDomain(String domainId) {
        this.domainIds.add(domainId);
        return this;
    }

    @Override
    public GraphClassifierBuilder addReleaseVersionId(String releaseVersionId) {
        this.releaseVersionIds.add(releaseVersionId);
        return this;
    }

    @Override
    public GraphClassifierBuilder addApplicationVersionId(String applicationVersionId) {
        this.applicationVersionIds.add(applicationVersionId);
        return this;
    }

    @Override
    public GraphClassifier build() {
        return new GraphClassifierImpl(this.id == null ? this.generateMD5Checksum() : this.id, this.withReport, this.departmentIds, this.domainIds, this.releaseVersionIds, this.applicationVersionIds);
    }

    private String generateMD5Checksum() {
        StringBuilder source = new StringBuilder();
        source.append("departmentIds: ").append(this.departmentIds);
        source.append(", domainsIds: ").append(this.domainIds);
        source.append(", releaseVersionIds: ").append(this.releaseVersionIds);
        source.append(", applicationVersionIds: ").append(this.applicationVersionIds);
        String md5 = DigestUtils.md5Hex((String)source.toString());
        return md5;
    }
}

