/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.qubership.itool.modules.artifactory.AppVersionDescriptor;
import org.qubership.itool.modules.artifactory.FailureStage;
import org.qubership.itool.modules.artifactory.GraphSnapshot;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphClassifier;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.modules.graph.GraphFetcher;
import org.qubership.itool.modules.processor.MergerApi;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphManager {
    protected static final Logger LOG = LoggerFactory.getLogger(GraphManager.class);
    private final LoadingCache<String, GraphClassifier> graphClassifierCache;
    private boolean failFast;
    private final GraphFetcher graphFetcher;
    private final Provider<Graph> graphProvider;
    private final Provider<GraphReport> graphReportProvider;
    private final Provider<MergerApi> graphMergerProvider;

    @Inject
    public GraphManager(Vertx vertx, GraphFetcher fetcher, boolean failFast, Provider<Graph> graphProvider, Provider<GraphReport> graphReportProvider, Provider<MergerApi> graphMergerProvider) {
        this(vertx, fetcher, GraphManager.defaultClassifierCacheBuilder(), failFast, graphProvider, graphReportProvider, graphMergerProvider);
    }

    protected static CacheBuilder defaultClassifierCacheBuilder() {
        return CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(16L).expireAfterAccess(Duration.ofDays(1L));
    }

    public GraphManager(Vertx vertx, GraphFetcher fetcher, CacheBuilder classifierCacheBuilder, boolean failFast, Provider<Graph> graphProvider, Provider<GraphReport> graphReportProvider, Provider<MergerApi> graphMergerProvider) {
        this.graphFetcher = fetcher;
        this.failFast = failFast;
        this.graphProvider = graphProvider;
        this.graphReportProvider = graphReportProvider;
        this.graphMergerProvider = graphMergerProvider;
        this.graphClassifierCache = classifierCacheBuilder.recordStats().build((CacheLoader)new ClassifierCacheLoader());
    }

    protected GraphClassifier resolveGraphClassifier(String graphClassifierId) {
        return this.graphFetcher.resolveGraphClassifier(graphClassifierId);
    }

    protected Graph buildGraphByClassifier(GraphClassifier classifier) {
        this.graphClassifierCache.put((Object)classifier.getId(), (Object)classifier);
        GraphSnapshot graphSnapshot = this.graphFetcher.fetchGraphDumpByClassifier(classifier);
        if (graphSnapshot != null && graphSnapshot.getGraphDump() != null) {
            Graph graph = (Graph)this.graphProvider.get();
            GraphDumpSupport.restoreFromJson(graph, graphSnapshot.getGraphDump());
            return graph;
        }
        List allAppVersionIds = ListUtils.emptyIfNull(this.graphFetcher.fetchAllApplicationVersionIds(classifier));
        Map<AppVersionDescriptor, GraphSnapshot> fetchedData = this.graphFetcher.fetchGraphDumpsByAppVersions(allAppVersionIds);
        HashMap<AppVersionDescriptor, GraphSnapshot> unprocessedAppIds = new HashMap<AppVersionDescriptor, GraphSnapshot>();
        for (AppVersionDescriptor applicationVersionId : allAppVersionIds) {
            GraphSnapshot snapshot = fetchedData.get(applicationVersionId);
            if (snapshot == null) {
                snapshot = new GraphSnapshot();
            }
            if (snapshot.getGraphDump() == null && snapshot.getFailureStage() == null) {
                snapshot.setFailureStage(FailureStage.FETCHING);
            }
            if (snapshot.getFailureStage() == null) continue;
            unprocessedAppIds.put(applicationVersionId, snapshot);
            fetchedData.remove(applicationVersionId);
        }
        Graph graph = (Graph)this.graphProvider.get();
        if (classifier.isWithReport()) {
            graph.setReport((GraphReport)this.graphReportProvider.get());
        }
        if (!this.failFast || unprocessedAppIds.isEmpty()) {
            try (MergerApi merger = (MergerApi)this.graphMergerProvider.get();){
                JsonObject targetInfo = new JsonObject();
                merger.prepareGraphForMerging(graph, targetInfo);
                Iterator<Map.Entry<AppVersionDescriptor, GraphSnapshot>> it = fetchedData.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<AppVersionDescriptor, GraphSnapshot> entry = it.next();
                    AppVersionDescriptor appId = entry.getKey();
                    GraphSnapshot snapshot = entry.getValue();
                    JsonObject sourceInfo = new JsonObject().put("isApplication", (Object)true).put("appName", (Object)appId.getAppName()).put("appVersion", (Object)appId.getAppVersion());
                    try {
                        merger.mergeDump(snapshot.getGraphDump(), sourceInfo, graph, targetInfo);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to merge: " + String.valueOf(appId), (Throwable)e);
                        it.remove();
                        unprocessedAppIds.put(appId, snapshot);
                        snapshot.setFailureStage(FailureStage.MERGING);
                        snapshot.setFailureDetails(e.toString());
                    }
                }
                merger.finalizeGraphAfterMerging(graph, targetInfo);
            }
            catch (IOException e) {
                LOG.error("Failed to close merger", (Throwable)e);
            }
        }
        if (this.failFast && !unprocessedAppIds.isEmpty()) {
            List artifactIds = unprocessedAppIds.keySet().stream().map(AppVersionDescriptor::asArtifactId).collect(Collectors.toList());
            throw new IllegalArgumentException("Invalid source graphs: " + String.valueOf(artifactIds));
        }
        graphSnapshot = new GraphSnapshot();
        graphSnapshot.setGraphDump(GraphDumpSupport.dumpToJson(graph, false));
        this.graphFetcher.persistGraphByClassifier(classifier, graphSnapshot, fetchedData, unprocessedAppIds);
        return graph;
    }

    protected CacheStats getCacheStatistics() {
        return this.graphClassifierCache.stats();
    }

    public void invalidate(GraphClassifier graphClassifier) {
        this.graphClassifierCache.invalidate((Object)graphClassifier.getId());
    }

    public void evictCache() {
        this.graphClassifierCache.invalidateAll();
    }

    class ClassifierCacheLoader
    extends CacheLoader<String, GraphClassifier> {
        ClassifierCacheLoader() {
        }

        public GraphClassifier load(String graphClassifierId) throws Exception {
            GraphClassifier graphClassifier = GraphManager.this.resolveGraphClassifier(graphClassifierId);
            if (graphClassifier == null) {
                throw new ExecutionException("GraphClassifier can't be loaded for: " + graphClassifierId, new NullPointerException());
            }
            return graphClassifier;
        }
    }
}

