/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graphExtractor;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.modules.graphExtractor.GraphDataExtractor;
import org.qubership.itool.utils.JsonArrayDeserializer;
import org.qubership.itool.utils.JsonObjectDeserializer;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphDataExtractor
implements GraphDataExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGraphDataExtractor.class);
    private static final ObjectMapper mapper = DatabindCodec.mapper().copy();

    @Override
    public abstract JsonObject getDataFromGraph(Graph var1);

    @Override
    public JsonObject extractGraphData(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        JsonObject graphDump = null;
        try {
            graphDump = (JsonObject)mapper.readValue((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to load graph from input stream: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        Graph graph = GraphDumpSupport.restoreFromJson(graphDump);
        return this.getDataFromGraph(graph);
    }

    @Override
    public JsonObject extractGraphData(Path graphFile) {
        if (!graphFile.toFile().exists()) {
            return new JsonObject();
        }
        Graph graph = null;
        try {
            JsonObject dumpFile = JsonUtils.readJsonFile(graphFile.toAbsolutePath().toString());
            graph = GraphDumpSupport.restoreFromJson(dumpFile);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to load graph resource using path {}: {}", (Object)graphFile, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return this.getDataFromGraph(graph);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JsonObject.class, (JsonDeserializer)new JsonObjectDeserializer());
        module.addDeserializer(JsonArray.class, (JsonDeserializer)new JsonArrayDeserializer());
        mapper.registerModule((Module)module);
    }
}

