/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qubership.itool.modules.gremlin2.Path;

public class DefaultPath
implements Path {
    protected List objects;
    protected List<Set<String>> labels;

    public DefaultPath() {
        this.objects = new ArrayList();
        this.labels = new ArrayList<Set<String>>();
    }

    public DefaultPath(List objects, List<Set<String>> labels) {
        this.objects = objects;
        this.labels = labels;
    }

    @Override
    public List<Set<String>> labels() {
        return this.labels;
    }

    @Override
    public List objects() {
        return this.objects;
    }

    @Override
    public Path extend(Object obj) {
        this.objects.add(obj);
        this.labels.add(new HashSet());
        return this;
    }

    @Override
    public Path extend(Object obj, String ... labels) {
        this.objects().add(obj);
        this.labels().add(new HashSet());
        this.extend(labels);
        return this;
    }

    @Override
    public Path extend(Object obj, Set<String> labels) {
        this.objects().add(obj);
        this.labels().add(new HashSet());
        this.extend(labels);
        return this;
    }

    @Override
    public Path extend(String ... labels) {
        if (labels == null || this.labels.size() == 0) {
            return this;
        }
        Set<String> set = this.labels.get(this.labels.size() - 1);
        for (String label : labels) {
            set.add(label);
        }
        return this;
    }

    @Override
    public Path extend(Set<String> labels) {
        if (labels == null || this.labels.size() == 0) {
            return this;
        }
        Set<String> set = this.labels.get(this.labels.size() - 1);
        set.addAll(labels);
        return this;
    }

    @Override
    public Path clone() {
        ArrayList cObjects = new ArrayList(this.objects);
        int size = this.labels.size();
        ArrayList<Set<String>> cLabels = new ArrayList<Set<String>>(size * 3);
        for (int i = 0; i < size; ++i) {
            Set<String> labelSet = this.labels.get(i);
            HashSet<String> cLabelSet = new HashSet<String>(labelSet);
            cLabels.add(cLabelSet);
        }
        DefaultPath clone = new DefaultPath(cObjects, cLabels);
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Path{\n");
        for (int i = 0; i < this.objects.size(); ++i) {
            builder.append(i + 1).append(") ");
            builder.append(this.labels.get(i)).append(" : ");
            builder.append(this.objects.get(i)).append("\n");
        }
        builder.append("}\n");
        return builder.toString();
    }
}

