/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.EmptyStep;
import org.qubership.itool.modules.gremlin2.step.util.Profile;

public interface Traversal<S, E>
extends Cloneable {
    default public Admin<S, E> asAdmin() {
        return (Admin)this;
    }

    public Traversal<S, E> clone();

    default public E next() {
        List<E> list = this.toList();
        return list == null || list.size() == 0 ? null : (E)list.get(0);
    }

    default public List<E> toList() {
        return this.fill(new ArrayList());
    }

    default public Set<E> toSet() {
        return this.fill(new HashSet());
    }

    default public <C extends Collection<E>> C fill(C collection) {
        Step<?, E> endStep;
        Profile profile = (Profile)this.asAdmin().getSideEffect("__profile");
        if (profile != null) {
            profile.start();
        }
        if (!this.asAdmin().isLocked()) {
            this.asAdmin().applyStrategies();
        }
        if ((endStep = this.asAdmin().getEndStep()) == null) {
            return collection;
        }
        for (Traverser<E> traverser : endStep.getTraversers()) {
            collection.add(traverser.get());
        }
        if (profile != null) {
            profile.stop();
        }
        return collection;
    }

    public static interface Admin<S, E>
    extends Traversal<S, E> {
        public static final Profile EMPTY_PROFILE = new Profile(){};

        default public Profile getProfile() {
            return EMPTY_PROFILE;
        }

        public List<Step> getSteps();

        default public <E2> Admin<S, E2> addStep(Step<?, E2> step) throws IllegalStateException {
            return this.addStep(this.getSteps().size(), step);
        }

        public <S2, E2> Admin<S2, E2> addStep(int var1, Step<?, ?> var2) throws IllegalStateException;

        public <S2, E2> Admin<S2, E2> replaceStep(int var1, Step<?, ?> var2) throws IllegalStateException;

        default public Step<S, ?> getStartStep() {
            List<Step> steps = this.getSteps();
            return steps.isEmpty() ? EmptyStep.getInstance() : steps.get(0);
        }

        default public Step<?, E> getEndStep() {
            List<Step> steps = this.getSteps();
            return steps.isEmpty() ? EmptyStep.getInstance() : steps.get(steps.size() - 1);
        }

        default public Object getSideEffect(String sideEffectKey) {
            return null;
        }

        default public void addSideEffect(String sideEffectKey, Object sideEffect) {
        }

        @Override
        public Admin<S, E> clone();

        public Admin<S, E> getPreviousTraversal();

        public void setPreviousTraversal(Admin<S, E> var1);

        public BasicGraph getGraph();

        public void setGraph(BasicGraph var1);

        public void applyStrategies() throws IllegalStateException;

        public boolean isLocked();

        public boolean isRoot();

        public void setRoot(boolean var1);

        public void addStart(Traverser.Admin<S> var1);

        default public void clear() {
            for (Step step : this.getSteps()) {
                step.clear();
            }
        }
    }
}

