/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversalSource;
import org.qubership.itool.modules.gremlin2.step.EmptyStep;
import org.qubership.itool.modules.gremlin2.step.StartStep;
import org.qubership.itool.modules.gremlin2.step.util.DefaultProfile;
import org.qubership.itool.modules.gremlin2.step.util.Profile;
import org.qubership.itool.modules.gremlin2.util.TraversalHelper;

public class DefaultGraphTraversal<S, E>
implements GraphTraversal<S, E>,
GraphTraversal.Admin<S, E> {
    protected Profile profile = new DefaultProfile();
    protected Map<String, Object> sideEffectMap = new HashMap<String, Object>();
    protected Traversal.Admin<S, E> previousTraversal;
    protected GraphTraversalSource graphTraversalSource;
    protected BasicGraph graph;
    protected List<Step> steps = new ArrayList<Step>();
    protected boolean locked = false;
    boolean root = false;

    public DefaultGraphTraversal() {
    }

    public DefaultGraphTraversal(GraphTraversalSource graphTraversalSource, boolean root) {
        this.root = root;
        this.setSource(graphTraversalSource);
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public GraphTraversal.Admin<S, E> asAdmin() {
        return this;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public <S2, E2> Traversal.Admin<S2, E2> addStep(int index, Step<?, ?> step) throws IllegalStateException {
        this.steps.add(index, step);
        EmptyStep previousStep = this.steps.size() > 0 && index != 0 ? this.steps.get(index - 1) : null;
        EmptyStep nextStep = this.steps.size() > index + 1 ? this.steps.get(index + 1) : null;
        step.setPreviousStep(null != previousStep ? previousStep : EmptyStep.getInstance());
        step.setNextStep(null != nextStep ? nextStep : EmptyStep.getInstance());
        if (null != previousStep) {
            previousStep.setNextStep(step);
        }
        if (null != nextStep) {
            nextStep.setPreviousStep(step);
        }
        step.setTraversal(this);
        return this;
    }

    @Override
    public <S2, E2> Traversal.Admin<S2, E2> replaceStep(int index, Step<?, ?> step) throws IllegalStateException {
        this.steps.remove(index);
        return this.addStep(index, step);
    }

    @Override
    public BasicGraph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(BasicGraph graph) {
        this.graph = graph;
    }

    @Override
    public void applyStrategies() throws IllegalStateException {
        if (!this.isRoot()) {
            throw new IllegalStateException("only for root traversal");
        }
        if (this.locked) {
            throw new IllegalStateException("Traversal is locked");
        }
        TraversalHelper.applyTraversalRecursively(this::apply, this);
        this.locked = true;
    }

    protected void apply(Traversal.Admin<?, ?> traversal) {
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public void setRoot(boolean isRoot) {
        this.root = isRoot;
    }

    @Override
    public void addStart(Traverser.Admin<S> innerTraverser) {
        ArrayList trList = new ArrayList();
        if (innerTraverser != null) {
            trList.add(innerTraverser);
        }
        if (this.getStartStep() instanceof StartStep) {
            ((StartStep)this.getStartStep()).setTraverserList(trList);
        } else {
            StartStep startStep = new StartStep(this, trList);
            this.addStep(0, startStep);
        }
    }

    @Override
    public GraphTraversal.Admin<S, E> clone() {
        DefaultGraphTraversal<S, E> clone = new DefaultGraphTraversal<S, E>(this.graphTraversalSource, this.root);
        clone.locked = this.locked;
        clone.previousTraversal = this.previousTraversal;
        clone.sideEffectMap = this.sideEffectMap;
        clone.profile = new DefaultProfile();
        for (Step step : this.steps) {
            Step newStep = step.clone();
            newStep.setTraversal(this);
            clone.addStep(newStep);
        }
        return clone;
    }

    @Override
    public Traversal.Admin<S, E> getPreviousTraversal() {
        return this.previousTraversal;
    }

    @Override
    public void setPreviousTraversal(Traversal.Admin<S, E> traversal) {
        this.previousTraversal = traversal;
    }

    @Override
    public Object getSideEffect(String sideEffectKey) {
        return this.sideEffectMap.get(sideEffectKey);
    }

    @Override
    public void addSideEffect(String sideEffectKey, Object sideEffect) {
        this.sideEffectMap.put(sideEffectKey, sideEffect);
    }

    @Override
    public GraphTraversalSource getSource() {
        return this.graphTraversalSource;
    }

    @Override
    public void setSource(GraphTraversalSource source) {
        this.graphTraversalSource = source;
        this.graph = source != null ? source.getGraph() : null;
    }
}

