/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.graph;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.DefaultGraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.step.GraphStep;
import org.qubership.itool.modules.gremlin2.util.ElementType;

public class GraphTraversalSource {
    private BasicGraph graph;

    public GraphTraversalSource(BasicGraph graph) {
        this.graph = graph;
    }

    public GraphTraversal<JsonObject, JsonObject> V(Traversal<?, ?> traversal) {
        ArrayList<String> vertexIds = new ArrayList<String>();
        List<?> objects = traversal.toList();
        for (Object vertex : objects) {
            if (vertex instanceof String) {
                vertexIds.add((String)vertex);
                continue;
            }
            if (vertex instanceof JsonObject) {
                JsonObject vrtx = (JsonObject)vertex;
                Object id = vrtx.getValue("id");
                if (id == null) {
                    throw new GremlinException("Inner Traversal result JsonObject must contain \"id\" key");
                }
                vertexIds.add((String)id);
                continue;
            }
            throw new GremlinException("Inner Traversal result must be String (vertexId) or JsonObject (vertex)");
        }
        return this.V(vertexIds);
    }

    public GraphTraversal<JsonObject, JsonObject> V(List<String> vertexIds) {
        return this.V(vertexIds.toArray(new String[vertexIds.size()]));
    }

    public GraphTraversal<JsonObject, JsonObject> V(String ... vertexIds) {
        GraphTraversalSource clone = this.clone();
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone, true);
        return traversal.addStep((Step)new GraphStep(traversal, JsonObject.class, true, ElementType.vertex, vertexIds));
    }

    public GraphTraversal<JsonObject, JsonObject> E(String ... edgeIds) {
        GraphTraversalSource clone = this.clone();
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone, true);
        return traversal.addStep((Step)new GraphStep(traversal, JsonObject.class, true, ElementType.edge, edgeIds));
    }

    public GraphTraversalSource clone() {
        GraphTraversalSource clone = new GraphTraversalSource(this.graph);
        return clone;
    }

    public BasicGraph getGraph() {
        return this.graph;
    }
}

