/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.EmptyStep;
import org.qubership.itool.modules.gremlin2.step.StartStep;
import org.qubership.itool.modules.gremlin2.util.EmptyTraversal;
import org.qubership.itool.modules.gremlin2.util.TraversalHelper;

public abstract class AbstractStep<S, E>
implements Step<S, E> {
    protected Set<String> labels = new HashSet<String>();
    protected Traversal.Admin traversal;
    protected Step<?, S> previousStep = EmptyStep.getInstance();
    protected Step<E, ?> nextStep = EmptyStep.getInstance();
    protected boolean ignoreEmptyTraverser = false;

    public AbstractStep(Traversal.Admin traversal) {
        this.traversal = traversal;
    }

    @Override
    public boolean isIgnoreEmptyTraverser() {
        return this.ignoreEmptyTraverser;
    }

    @Override
    public void setIgnoreEmptyTraverser(boolean ignoreEmptyTraverser) {
        this.ignoreEmptyTraverser = ignoreEmptyTraverser;
    }

    protected Traversal.Admin fetchRootTraversal() {
        Traversal.Admin previousTraversal = this.traversal;
        while (previousTraversal.getPreviousTraversal() != null) {
            previousTraversal = previousTraversal.getPreviousTraversal();
        }
        return previousTraversal;
    }

    @Override
    public void addLabel(String label) {
        this.labels.add(label);
    }

    @Override
    public void removeLabel(String label) {
        this.labels.remove(label);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    @Override
    public void setPreviousStep(Step<?, S> step) {
        this.previousStep = step;
    }

    @Override
    public Step<?, S> getPreviousStep() {
        return this.previousStep;
    }

    @Override
    public void setNextStep(Step<E, ?> step) {
        this.nextStep = step;
    }

    @Override
    public Step<E, ?> getNextStep() {
        return this.nextStep;
    }

    @Override
    public <A, B> Traversal.Admin<A, B> getTraversal() {
        return this.traversal;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> traversal) {
        this.traversal = traversal;
    }

    protected JsonObject requireSourceVertex(Traverser.Admin<JsonObject> traverser) throws GremlinException {
        JsonObject sourceVertex = null;
        BasicGraph graph = this.traversal.getGraph();
        if (graph != null && (sourceVertex = traverser.getSource()) == null) {
            sourceVertex = (JsonObject)traverser.get();
        }
        if (sourceVertex == null || graph.getVertex(sourceVertex.getString("id")) != sourceVertex) {
            throw new GremlinException("Step " + this.getClass().getSimpleName() + " applicable only to Vertex");
        }
        return sourceVertex;
    }

    @Override
    public AbstractStep<S, E> clone() {
        try {
            AbstractStep clone = (AbstractStep)super.clone();
            clone.previousStep = EmptyStep.getInstance();
            clone.nextStep = EmptyStep.getInstance();
            clone.traversal = EmptyTraversal.getInstance();
            clone.labels = new HashSet<String>(this.labels);
            clone.ignoreEmptyTraverser = this.ignoreEmptyTraverser;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<Traverser<E>> getTraversers() {
        ArrayList<Traverser<E>> result = new ArrayList<Traverser<E>>();
        List<Traverser<S>> previousTraversers = this.fetchPreviousTraversers();
        this.traversal.getProfile().profileStep(this, step -> {
            this.processAllPreviousTraversers(previousTraversers, result);
            this.filterEmptyTraverserIfRequired(result);
            this.applyLabelsModulator(result);
            return result;
        });
        return result;
    }

    protected List<Traverser<S>> fetchPreviousTraversers() {
        Step<?, S> previousStep = this.getPreviousStep();
        List<Traverser<S>> previousTraversers = previousStep.getTraversers();
        return previousTraversers;
    }

    protected void processAllPreviousTraversers(List<Traverser<S>> previousTraversers, List<Traverser<E>> result) {
        for (Traverser<S> previousTraverser : previousTraversers) {
            this.processPreviousTraverser((Traverser.Admin)previousTraverser, result);
        }
    }

    protected void filterEmptyTraverserIfRequired(List<Traverser<E>> result) {
        if (this.isIgnoreEmptyTraverser()) {
            ListIterator<Traverser<E>> listIterator = result.listIterator();
            while (listIterator.hasNext()) {
                Traverser<E> traverser = listIterator.next();
                if (traverser.get() != null) continue;
                listIterator.remove();
            }
        }
    }

    protected void applyLabelsModulator(List<Traverser<E>> result) {
        if (this.labels.size() != 0) {
            for (Traverser<E> traverser : result) {
                traverser.path().extend(this.labels.toArray(new String[0]));
            }
        }
    }

    protected abstract void processPreviousTraverser(Traverser.Admin<S> var1, List<Traverser<E>> var2);

    protected Traversal.Admin<?, E> prepareInnerTraversal(Traversal.Admin<?, E> innerTraversal, Traverser.Admin<S> previousTraverser) {
        Traversal cloneTraversal = innerTraversal.clone();
        cloneTraversal.clear();
        TraversalHelper.propagateSource(this.traversal, cloneTraversal);
        cloneTraversal.setPreviousTraversal(this.traversal);
        cloneTraversal.setRoot(true);
        cloneTraversal.setGraph(this.traversal.getGraph());
        cloneTraversal.addStart((Traverser.Admin)previousTraverser.clone());
        return cloneTraversal;
    }

    protected Traversal.Admin<?, E> prepareInnerTraversal(Traversal.Admin<?, E> innerTraversal, List<Traverser.Admin<S>> list) {
        Traversal cloneTraversal = innerTraversal.clone();
        cloneTraversal.clear();
        TraversalHelper.propagateSource(this.traversal, cloneTraversal);
        cloneTraversal.setPreviousTraversal(this.traversal);
        cloneTraversal.setRoot(true);
        cloneTraversal.setGraph(this.traversal.getGraph());
        cloneTraversal.addStart(null);
        ((StartStep)cloneTraversal.getStartStep()).setTraverserList(list);
        return cloneTraversal;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void clearTraversal(Traversal.Admin traversal) {
        if (traversal != null) {
            traversal.clear();
        }
    }
}

