/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.barrier;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.gremlin2.DefaultTraverser;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.barrier.ReducingBarrierStep;
import org.qubership.itool.modules.gremlin2.util.ValueHelper;

public class GroupStep<S, K, V>
extends ReducingBarrierStep<S, Map<K, V>>
implements ByModulating {
    private String[] modulateBy;
    private String[] modulateByBy;
    private Traversal.Admin modulateByTraversal;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.modulateBy == null ? "" : this.modulateBy) + (String)(this.modulateByBy == null ? "" : "," + String.valueOf(this.modulateByBy)) + (this.modulateByTraversal == null ? "" : "traversal") + ")";
    }

    @Override
    public void clear() {
        this.clearTraversal(this.modulateByTraversal);
    }

    public GroupStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Map<K, V> projectTraversers(List<Traverser<S>> previousTraversers) {
        List resultList;
        HashMap<S, ArrayList<S>> result = new HashMap<S, ArrayList<S>>();
        HashMap<Object, ArrayList<Traverser<Object>>> resultBy = null;
        HashMap resultByBy = null;
        for (Traverser<S> traverser : previousTraversers) {
            S obj = traverser.get();
            ArrayList<S> objList = (ArrayList<S>)result.get(obj);
            if (objList == null) {
                objList = new ArrayList<S>();
                result.put(obj, objList);
            }
            objList.add(obj);
        }
        if (this.modulateBy != null) {
            resultBy = new HashMap<Object, ArrayList<Traverser<Object>>>();
            for (Traverser<Object> resultKey : result.keySet()) {
                Object byKey = this.extractByValue(resultKey, this.modulateBy);
                if (byKey == null) continue;
                ArrayList<Traverser<Object>> resultByList = (ArrayList<Traverser<Object>>)resultBy.get(byKey);
                for (Object obj : (List)result.get(resultKey)) {
                    if (resultByList == null) {
                        resultByList = new ArrayList<Traverser<Object>>();
                        resultBy.put(byKey, resultByList);
                    }
                    resultByList.add(resultKey);
                }
            }
        }
        if (this.modulateByBy != null) {
            resultByBy = new HashMap();
            for (Traverser<Object> resultKey : resultBy.keySet()) {
                resultList = (List)resultBy.get(resultKey);
                ArrayList<Object> newList = new ArrayList<Object>();
                resultByBy.put(resultKey, newList);
                for (Object obj : resultList) {
                    Object value = this.extractByValue(obj, this.modulateByBy);
                    if (value == null) continue;
                    newList.add(value);
                }
            }
        }
        if (this.modulateByTraversal != null) {
            resultByBy = new HashMap();
            if (resultBy == null) {
                resultBy = result;
            }
            for (Traverser<Object> resultKey : resultBy.keySet()) {
                resultList = (List)resultBy.get(resultKey);
                ArrayList trList = new ArrayList();
                for (Object obj : resultList) {
                    trList.add(new DefaultTraverser(obj));
                }
                Traversal.Admin cloneTraversal = this.prepareInnerTraversal(this.modulateByTraversal, trList);
                List modulateList = cloneTraversal.toList();
                if (modulateList.size() > 1) {
                    resultByBy.put(resultKey, modulateList);
                    continue;
                }
                if (modulateList.size() != 1) continue;
                resultByBy.put(resultKey, modulateList.get(0));
            }
        }
        if (resultByBy != null) {
            return resultByBy;
        }
        if (resultBy != null) {
            return resultBy;
        }
        return result;
    }

    private Object extractByValue(Object obj, String ... modulateBy) {
        Object result = null;
        if (modulateBy.length == 1) {
            result = this.extractByValue(obj, modulateBy[0]);
        } else {
            result = new HashMap();
            for (int i = 0; i < modulateBy.length; ++i) {
                ((Map)result).put(modulateBy[i], this.extractByValue(obj, modulateBy[i]));
            }
        }
        return result;
    }

    private Object extractByValue(Object obj, String modulateBy) {
        Object result;
        if (obj instanceof JsonObject) {
            JsonObject json = (JsonObject)obj;
            result = ValueHelper.getObjectValue(modulateBy, json);
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            result = map.get(modulateBy);
        } else {
            throw new UnsupportedOperationException("Modulation .by() not supported for " + obj.getClass().getSimpleName());
        }
        return result;
    }

    @Override
    public void modulateBy(String string) throws UnsupportedOperationException {
        if (this.modulateBy == null) {
            this.modulateBy = new String[]{string};
        } else if (this.modulateByBy == null) {
            this.modulateByBy = new String[]{string};
        } else {
            throw new UnsupportedOperationException("only two .by() modulation allowed for GroupStep()");
        }
    }

    @Override
    public void modulateBy(String ... args) throws UnsupportedOperationException {
        if (this.modulateBy == null) {
            this.modulateBy = args;
        } else if (this.modulateByBy == null) {
            this.modulateByBy = args;
        } else {
            throw new UnsupportedOperationException("only two .by() modulation allowed for GroupStep()");
        }
    }

    @Override
    public void modulateBy(Traversal traversal) throws UnsupportedOperationException {
        this.modulateByTraversal = (Traversal.Admin)traversal;
    }

    @Override
    public AbstractStep<S, Map<K, V>> clone() {
        GroupStep clone = (GroupStep)super.clone();
        clone.modulateBy = this.modulateBy;
        clone.modulateByBy = this.modulateByBy;
        clone.modulateByTraversal = this.modulateByTraversal;
        return clone;
    }
}

