/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.barrier;

import java.util.Iterator;
import java.util.List;
import org.qubership.itool.modules.gremlin2.Path;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.barrier.ReducingBarrierStep;
import org.qubership.itool.modules.gremlin2.step.util.Tree;
import org.qubership.itool.modules.gremlin2.util.ValueHelper;

public class TreeStep<S>
extends ReducingBarrierStep<S, Tree>
implements ByModulating {
    private String modulateBy;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.modulateBy + ")";
    }

    public TreeStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Tree projectTraversers(List<Traverser<S>> previousTraversers) {
        Tree tree = new Tree();
        for (Traverser<S> traverser : previousTraversers) {
            Path path = traverser.path();
            List pathObjectList = path.objects();
            Tree innerTree = tree;
            Iterator iterator = pathObjectList.iterator();
            while (iterator.hasNext()) {
                Object pathObj;
                Object value = pathObj = iterator.next();
                if (this.modulateBy != null) {
                    value = ValueHelper.getObjectValue(this.modulateBy, pathObj);
                }
                innerTree = innerTree.add(value);
            }
        }
        return tree;
    }

    @Override
    public void modulateBy(String string) throws UnsupportedOperationException {
        this.modulateBy = string;
    }

    @Override
    public TreeStep<S> clone() {
        TreeStep clone = (TreeStep)super.clone();
        clone.modulateBy = this.modulateBy;
        return clone;
    }
}

