/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.branch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.branch.LocalStep;
import org.qubership.itool.utils.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinStep<S, E>
extends LocalStep<S, E> {
    protected static final Logger LOG = LoggerFactory.getLogger(ForkJoinStep.class);
    protected ForkJoinPool pool;

    public <E2> ForkJoinStep(Traversal.Admin traversal, Traversal<?, E2> innerTraversal, ForkJoinPool pool) {
        super(traversal, innerTraversal.asAdmin());
        this.pool = pool;
    }

    @Override
    protected void processAllPreviousTraversers(List<Traverser<S>> previousTraversers, List<Traverser<E>> result) {
        ArrayList subtasks = new ArrayList();
        for (final Traverser<S> previousTraverser : previousTraversers) {
            RecursiveTask subtask = new RecursiveTask<List<Traverser<E>>>(){

                @Override
                protected List<Traverser<E>> compute() {
                    ArrayList subResults = new ArrayList();
                    ForkJoinStep.this.processPreviousTraverser((Traverser.Admin)previousTraverser, subResults);
                    return subResults;
                }
            };
            subtasks.add(subtask);
        }
        LOG.info("Forking to {} tasks", (Object)subtasks.size());
        List<List> subResults = FutureUtils.invokeAndJoin(subtasks, this.pool);
        for (List subResult : subResults) {
            result.addAll(subResult);
        }
    }
}

