/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.branch;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.graph.lambda.TrueTraversal;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.TimesModulating;
import org.qubership.itool.modules.gremlin2.util.TraversalHelper;

public class RepeatStep<S>
extends AbstractStep
implements TimesModulating {
    private Traversal.Admin<S, S> repeatTraversal = null;
    private Traversal.Admin<S, ?> untilTraversal = null;
    private Traversal.Admin<S, ?> emitTraversal = null;
    private String loopName = null;
    private boolean untilFirst = false;
    private boolean emitFirst = false;
    private int maxLoops = 0;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + (String)(this.untilTraversal == null ? "noUntil" : "until-" + (this.untilFirst ? "before" : "after")) + "," + (String)(this.emitTraversal == null ? "noUntil" : "emit-" + (this.emitFirst ? "before" : "after")) + ")";
    }

    public RepeatStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    public void clear() {
        this.clearTraversal(this.repeatTraversal);
        this.clearTraversal(this.untilTraversal);
        this.clearTraversal(this.emitTraversal);
    }

    protected void processPreviousTraverser(Traverser.Admin previousTraverser, List result) {
        if (this.repeatTraversal == null) {
            throw new IllegalStateException("RepeatStep required repeat traversal");
        }
        ArrayList<S> path = new ArrayList<S>();
        List<Traverser<S>> tmpResultList = new ArrayList<Traverser<S>>();
        tmpResultList.add(previousTraverser);
        int currentLoop = 0;
        while ((tmpResultList = this.filterLoopedPath(path, tmpResultList)).size() != 0) {
            ++currentLoop;
            if (this.untilFirst && this.untilTraversal != null) {
                this.doUntil(result, tmpResultList);
            }
            if (this.emitFirst && this.emitTraversal != null) {
                this.doEmit(result, tmpResultList);
            }
            ArrayList<Traverser<S>> tmpList = new ArrayList<Traverser<S>>();
            for (Traverser<S> traverser : tmpResultList) {
                Traversal.Admin<S, S> cloneTraversal_02 = this.prepareInnerTraversal(this.repeatTraversal, (Traverser.Admin)traverser);
                tmpList.addAll(cloneTraversal_02.getEndStep().getTraversers());
            }
            if (!this.untilFirst && this.untilTraversal != null) {
                this.doUntil(result, tmpList);
            }
            if (!this.emitFirst && this.emitTraversal != null) {
                this.doEmit(result, tmpList);
            }
            for (Traverser<S> traverser : tmpResultList) {
                path.add(traverser.get());
            }
            tmpResultList = tmpList;
            if (this.loopHasNext(currentLoop, tmpResultList)) continue;
        }
        if (this.emitTraversal == null || this.emitFirst) {
            result.addAll(tmpResultList);
        }
    }

    private List<Traverser<S>> filterLoopedPath(List path, List<Traverser<S>> tmpResultList) {
        if (path.size() > 10000) {
            throw new IllegalStateException("Too long path (>10k size)");
        }
        ArrayList<Traverser<S>> result = new ArrayList<Traverser<S>>();
        int size = tmpResultList.size();
        for (int i = 0; i < size; ++i) {
            Traverser<S> traverser = tmpResultList.get(i);
            if (path.contains(traverser.get())) continue;
            result.add(traverser);
        }
        return result;
    }

    private boolean loopHasNext(int currentLoop, List<Traverser<S>> tmpResultList) {
        if (this.maxLoops != 0) {
            return currentLoop < this.maxLoops;
        }
        return tmpResultList.size() != 0;
    }

    private void doUntil(List result, List<Traverser<S>> tmpList) {
        ListIterator<Traverser<S>> listIterator = tmpList.listIterator();
        while (listIterator.hasNext()) {
            Traverser.Admin traverser = (Traverser.Admin)listIterator.next();
            if (!this.filterByTraversal(this.untilTraversal, traverser)) continue;
            result.add(traverser);
            listIterator.remove();
        }
    }

    private void doEmit(List result, List<Traverser<S>> tmpResultList) {
        for (Traverser<S> traverser : tmpResultList) {
            if (!this.filterByTraversal(this.emitTraversal, (Traverser.Admin)traverser)) continue;
            result.add(traverser);
        }
    }

    private boolean filterByTraversal(Traversal.Admin<?, ?> traversal, Traverser.Admin<S> traverser) {
        if (traversal instanceof TrueTraversal) {
            return true;
        }
        Traversal.Admin<?, ?> cloneTraversal = this.prepareInnerTraversal(traversal, traverser);
        Object result = cloneTraversal.next();
        return result != null;
    }

    @Override
    public void modulateTimes(int maxLoops) {
        this.maxLoops = maxLoops;
    }

    @Override
    public AbstractStep clone() {
        RepeatStep clone = (RepeatStep)super.clone();
        clone.repeatTraversal = this.repeatTraversal;
        clone.untilTraversal = this.untilTraversal;
        clone.emitTraversal = this.emitTraversal;
        clone.loopName = this.loopName;
        clone.emitFirst = this.emitFirst;
        clone.untilFirst = this.untilFirst;
        clone.maxLoops = this.maxLoops;
        return clone;
    }

    public Traversal.Admin<S, S> getRepeatTraversal() {
        return this.repeatTraversal;
    }

    public void setRepeatTraversal(Traversal.Admin<S, S> repeatTraversal) {
        this.repeatTraversal = repeatTraversal;
    }

    public Traversal.Admin<S, ?> getUntilTraversal() {
        return this.untilTraversal;
    }

    public void setUntilTraversal(Traversal.Admin<S, ?> untilTraversal) {
        this.untilTraversal = untilTraversal;
    }

    public Traversal.Admin<S, ?> getEmitTraversal() {
        return this.emitTraversal;
    }

    public void setEmitTraversal(Traversal.Admin<S, ?> emitTraversal) {
        this.emitTraversal = emitTraversal;
    }

    public boolean isUntilFirst() {
        return this.untilFirst;
    }

    public void setUntilFirst(boolean untilFirst) {
        this.untilFirst = untilFirst;
    }

    public boolean isEmitFirst() {
        return this.emitFirst;
    }

    public void setEmitFirst(boolean emitFirst) {
        this.emitFirst = emitFirst;
    }

    public static <A, B, C extends Traversal<A, B>> C addRepeatToTraversal(C traversal, Traversal.Admin<B, B> repeatTraversal) {
        Step<?, B> endStep = traversal.asAdmin().getEndStep();
        TraversalHelper.propagateSource(traversal, repeatTraversal);
        if (endStep instanceof RepeatStep && null == ((RepeatStep)endStep).repeatTraversal) {
            ((RepeatStep)endStep).setRepeatTraversal(repeatTraversal);
        } else {
            RepeatStep<B> repeatStep = new RepeatStep<B>(traversal.asAdmin());
            repeatStep.setRepeatTraversal(repeatTraversal);
            traversal.asAdmin().addStep(repeatStep);
        }
        return traversal;
    }

    public static <A, B, C extends Traversal<A, B>> C addUntilToTraversal(C traversal, Traversal.Admin<B, ?> untilPredicate) {
        Step<?, B> step = traversal.asAdmin().getEndStep();
        if (step instanceof RepeatStep && null == ((RepeatStep)step).untilTraversal) {
            ((RepeatStep)step).setUntilTraversal(untilPredicate);
        } else {
            RepeatStep<B> repeatStep = new RepeatStep<B>(traversal.asAdmin());
            repeatStep.setUntilTraversal(untilPredicate);
            repeatStep.setUntilFirst(true);
            traversal.asAdmin().addStep(repeatStep);
        }
        return traversal;
    }

    public static <A, B, C extends Traversal<A, B>> C addEmitToTraversal(C traversal, Traversal.Admin<B, ?> emitPredicate) {
        Step<?, B> step = traversal.asAdmin().getEndStep();
        if (step instanceof RepeatStep && null == ((RepeatStep)step).emitTraversal) {
            ((RepeatStep)step).setEmitTraversal(emitPredicate);
        } else {
            RepeatStep<B> repeatStep = new RepeatStep<B>(traversal.asAdmin());
            repeatStep.setEmitTraversal(emitPredicate);
            repeatStep.setEmitFirst(true);
            traversal.asAdmin().addStep(repeatStep);
        }
        return traversal;
    }
}

