/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.filter;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.filter.FilterStep;
import org.qubership.itool.modules.gremlin2.step.util.HasContainer;
import org.qubership.itool.modules.gremlin2.step.util.HasContainerHolder;
import org.qubership.itool.modules.gremlin2.util.TraversalHelper;
import org.qubership.itool.modules.gremlin2.util.ValueHelper;

public class HasStep<S>
extends FilterStep<S>
implements HasContainerHolder {
    private String type;
    private List<HasContainer> hasContainers;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + (String)(this.type == null ? "" : this.type + ",") + String.valueOf(this.hasContainers) + ")";
    }

    public HasStep(Traversal.Admin traversal, HasContainer hasContainer) {
        super(traversal);
        this.hasContainers = new ArrayList<HasContainer>();
        this.hasContainers.add(hasContainer);
    }

    public HasStep(Traversal.Admin traversal, String type, HasContainer hasContainer) {
        super(traversal);
        this.type = type;
        this.hasContainers = new ArrayList<HasContainer>();
        this.hasContainers.add(hasContainer);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        JsonObject json;
        if (this.type != null && traverser.get() instanceof JsonObject && !this.type.equals((json = (JsonObject)traverser.get()).getString("type"))) {
            return false;
        }
        boolean result = true;
        for (HasContainer hasContainer : this.hasContainers) {
            Object obj = traverser.get();
            Object value = ValueHelper.getObjectValue(hasContainer.getPropertyKey(), obj);
            Object predicateValue = hasContainer.getPredicate().getValue();
            if (predicateValue instanceof Traversal) {
                Traversal predicateTraversal = ((Traversal.Admin)predicateValue).clone();
                TraversalHelper.propagateSource(this.traversal, predicateTraversal);
                predicateTraversal.setRoot(true);
                predicateTraversal.addStart((Traverser.Admin)traverser.clone());
                predicateValue = predicateTraversal.next();
                hasContainer.getPredicate().setOriginalValue(predicateValue);
            }
            if (!hasContainer.test(value)) {
                result = false;
                break;
            }
            hasContainer.getPredicate().setOriginalValue(null);
        }
        return result;
    }

    @Override
    public AbstractStep<S, S> clone() {
        HasStep clone = (HasStep)super.clone();
        clone.type = this.type;
        clone.hasContainers = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : this.hasContainers) {
            clone.hasContainers.add(hasContainer);
        }
        return clone;
    }

    @Override
    public List<HasContainer> getHasContainers() {
        return this.hasContainers;
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        if (this.hasContainers == null) {
            this.hasContainers = new ArrayList<HasContainer>();
        }
        this.hasContainers.add(hasContainer);
    }
}

