/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.filter;

import java.util.List;
import java.util.Optional;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.filter.FilterStep;

public class RangeLimitStep<S>
extends FilterStep<S> {
    private Optional<Integer> rangeFrom;
    private Optional<Integer> rangeTo;
    private int rangePosition = 0;
    private int rangeSize = 0;

    public RangeLimitStep(Traversal.Admin traversal, Optional<Integer> rangeFrom, Optional<Integer> rangeTo) {
        super(traversal);
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeTo;
    }

    @Override
    public void clear() {
        this.rangeSize = 0;
        this.rangePosition = 0;
    }

    @Override
    protected void processAllPreviousTraversers(List<Traverser<S>> previousTraversers, List<Traverser<S>> result) {
        this.rangeSize = previousTraversers.size();
        super.processAllPreviousTraversers(previousTraversers, result);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        boolean result = false;
        if (this.rangeFrom.isEmpty() && this.rangeTo.isEmpty()) {
            result = true;
        } else if (this.rangeFrom.isPresent() && this.rangeTo.isPresent() && this.rangePosition >= this.rangeFrom.get() && this.rangePosition < this.rangeTo.get()) {
            result = true;
        } else if (this.rangeFrom.isPresent() && this.rangeTo.isEmpty() && this.rangePosition >= this.rangeSize - this.rangeFrom.get()) {
            result = true;
        } else if (this.rangeFrom.isEmpty() && this.rangeTo.isPresent() && this.rangePosition < this.rangeTo.get()) {
            result = true;
        }
        ++this.rangePosition;
        return result;
    }

    @Override
    public AbstractStep<S, S> clone() {
        RangeLimitStep clone = (RangeLimitStep)super.clone();
        clone.rangeFrom = this.rangeFrom;
        clone.rangeTo = this.rangeTo;
        clone.rangePosition = 0;
        clone.rangeSize = 0;
        return clone;
    }
}

