/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.map.flat;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.FlatMapStep;
import org.qubership.itool.modules.gremlin2.structure.Direction;

public class EdgeStep<E extends JsonObject>
extends FlatMapStep<JsonObject, E> {
    private String[] edgeLabels;
    private Direction direction;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf((Object)this.direction) + "," + String.valueOf(Arrays.asList(this.edgeLabels)) + ")";
    }

    public EdgeStep(Traversal.Admin traversal, Direction direction, String ... edgeLabels) {
        super(traversal);
        this.direction = direction;
        this.edgeLabels = edgeLabels;
    }

    @Override
    protected Traverser<E> generateTraverser(Traverser.Admin<JsonObject> previousTraverser, E value) {
        Traverser.Admin<E> traverser = previousTraverser.split((JsonObject)value, value, this);
        return traverser;
    }

    @Override
    protected List<E> flatMap(Traverser.Admin<JsonObject> traverser) {
        ArrayList result = new ArrayList();
        BasicGraph graph = this.traversal.getGraph();
        JsonObject sourceVertex = null;
        if (graph != null && (sourceVertex = traverser.getSource()) == null) {
            sourceVertex = (JsonObject)traverser.get();
        }
        if (sourceVertex == null || graph.getVertex(sourceVertex.getString("id")) != sourceVertex) {
            throw new GremlinException("Step " + this.getClass().getSimpleName() + " applicable only to Vertex");
        }
        switch (this.direction) {
            case OUT: {
                this.fillResult(graph.getSuccessorEdges(sourceVertex.getString("id")), result);
                break;
            }
            case IN: {
                this.fillResult(graph.getPredecessorEdges(sourceVertex.getString("id")), result);
                break;
            }
            case BOTH: {
                this.fillResult(graph.getSuccessorEdges(sourceVertex.getString("id")), result);
                this.fillResult(graph.getPredecessorEdges(sourceVertex.getString("id")), result);
            }
        }
        return result;
    }

    private void fillResult(List<JsonObject> edges, List<E> result) {
        for (JsonObject edge : edges) {
            if (this.edgeLabels.length == 0) {
                result.add(edge);
                continue;
            }
            String edgeType = edge.getString("type");
            for (String type : this.edgeLabels) {
                if (!type.equals(edgeType)) continue;
                result.add(edge);
            }
        }
    }

    @Override
    public AbstractStep<JsonObject, E> clone() {
        EdgeStep clone = (EdgeStep)super.clone();
        clone.edgeLabels = this.edgeLabels;
        clone.direction = this.direction;
        return clone;
    }
}

