/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.map.scalar;

import org.qubership.itool.modules.gremlin2.Path;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.FromToModulating;
import org.qubership.itool.modules.gremlin2.step.map.scalar.ScalarMapStep;
import org.qubership.itool.modules.gremlin2.util.ValueHelper;

public class PathStep<S>
extends ScalarMapStep<S, Path>
implements FromToModulating,
ByModulating {
    private String fromLabel;
    private String toLabel;
    private String modulateBy;

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        if (this.modulateBy != null) {
            builder.append("(").append(this.modulateBy).append(")");
        }
        return builder.toString();
    }

    public PathStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Path map(Traverser.Admin<S> traverser) {
        Path path = traverser.path().clone();
        if (this.modulateBy != null) {
            for (int i = 0; i < path.objects().size(); ++i) {
                Object obj = path.objects().get(i);
                Object value = ValueHelper.getObjectValue(this.modulateBy, obj);
                path.objects().set(i, value);
            }
        }
        return path;
    }

    @Override
    public void modulateBy(String string) throws UnsupportedOperationException {
        this.modulateBy = string;
    }

    @Override
    public void addFrom(String fromLabel) {
        this.fromLabel = fromLabel;
    }

    @Override
    public void addTo(String toLabel) {
        this.toLabel = toLabel;
    }

    @Override
    public AbstractStep<S, Path> clone() {
        PathStep clone = (PathStep)super.clone();
        clone.fromLabel = this.fromLabel;
        clone.toLabel = this.toLabel;
        clone.modulateBy = this.modulateBy;
        return clone;
    }
}

