/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.util.Profile;

public class DefaultProfile
implements Profile {
    public static final String TIME = "time";
    public static final String TRAVERSERS = "traversers";
    public static final String STEP = "step";
    public static final String DUR = "duration";
    private boolean started;
    private List<Map<String, Object>> steps = new ArrayList<Map<String, Object>>();

    @Override
    public <S, E> void addInfo(long startTime, long endTime, AbstractStep<S, E> step, List result) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put(TIME, endTime - startTime);
        entry.put(TRAVERSERS, result.size());
        entry.put(STEP, step.toString());
        this.steps.add(entry);
    }

    @Override
    public boolean isStart() {
        return this.started;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    public String toString() {
        long totalTime = 0L;
        for (Map<String, Object> entry : this.steps) {
            totalTime += ((Long)entry.get(TIME)).longValue();
        }
        for (Map<String, Object> entry : this.steps) {
            entry.put(DUR, Float.valueOf(((Long)entry.get(TIME)).floatValue() / (float)totalTime * 100.0f));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Profile{\n");
        String header = String.format("| %1$-60s | %2$-10s | %3$-10s | %4$-10s |", "Step", "Traversers", "Time (ms)", "% Dur");
        builder.append("=".repeat(header.length())).append("\n");
        builder.append(header).append("\n");
        builder.append("=".repeat(header.length())).append("\n");
        for (Map<String, Object> entry : this.steps) {
            String line = String.format("| %1$-60s | %2$10d | %3$10d | %4$10.2f |", entry.get(STEP), entry.get(TRAVERSERS), entry.get(TIME), entry.get(DUR));
            builder.append(line).append("\n");
        }
        builder.append("=".repeat(header.length())).append("\n");
        String total = String.format("| %1$60s | %2$10s | %3$10d | %4$10s |", "Total:", "-", totalTime, "-");
        builder.append(total).append("\n");
        builder.append("=".repeat(header.length())).append("\n");
        builder.append("}");
        return builder.toString();
    }
}

