/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.DefaultGraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.step.TraversalParent;
import org.qubership.itool.modules.gremlin2.step.filter.HasStep;
import org.qubership.itool.modules.gremlin2.step.filter.OrStep;
import org.qubership.itool.modules.gremlin2.step.util.HasContainer;
import org.qubership.itool.modules.gremlin2.step.util.HasContainerHolder;

public class TraversalHelper {
    private TraversalHelper() {
    }

    public static <S> void addToCollection(Collection<S> collection, S s) {
        if (s instanceof List) {
            collection.addAll((List)s);
        } else {
            collection.add(s);
        }
    }

    public static void applyTraversalRecursively(Consumer<Traversal.Admin<?, ?>> consumer, Traversal.Admin<?, ?> traversal) {
        consumer.accept(traversal);
        List<Step> steps = traversal.getSteps();
        for (int ix = 0; ix < steps.size(); ++ix) {
            Step step = steps.get(ix);
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin local : ((TraversalParent)((Object)step)).getLocalChildren()) {
                TraversalHelper.applyTraversalRecursively(consumer, local);
            }
            for (Traversal.Admin global : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                TraversalHelper.applyTraversalRecursively(consumer, global);
            }
        }
    }

    public static <T extends Traversal.Admin<?, ?>> T addHasContainer(T traversal, HasContainer hasContainer) {
        if (traversal.getEndStep() instanceof HasContainerHolder) {
            ((HasContainerHolder)((Object)traversal.getEndStep())).addHasContainer(hasContainer);
            return traversal;
        }
        return (T)traversal.addStep(new HasStep(traversal, hasContainer));
    }

    public static <T extends Traversal.Admin<?, ?>> T addHasContainer(T traversal, String type, HasContainer hasContainer) {
        if (traversal.getEndStep() instanceof HasContainerHolder) {
            ((HasContainerHolder)((Object)traversal.getEndStep())).addHasContainer(hasContainer);
            return traversal;
        }
        return (T)traversal.addStep(new HasStep(traversal, type, hasContainer));
    }

    public static <T extends Traversal.Admin<?, ?>> T addHasOrContainer(T traversal, HasContainer hasContainer) {
        if (!(traversal.getEndStep() instanceof OrStep)) {
            traversal.addStep(new OrStep(traversal, new Traversal.Admin[0]));
        }
        OrStep orStep = (OrStep)traversal.getEndStep();
        orStep.appendOrTraversals(new DefaultGraphTraversal().addStep((Step)new HasStep(traversal, hasContainer)));
        return traversal;
    }

    public static void propagateSource(Traversal source, Traversal target) {
        Traversal.Admin targetAsAdmin;
        if (source instanceof GraphTraversal && target instanceof GraphTraversal && (targetAsAdmin = ((GraphTraversal)target).asAdmin()).getSource() == null) {
            targetAsAdmin.setSource(((GraphTraversal)source).asAdmin().getSource());
        }
    }
}

