/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.util;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.utils.JsonUtils;

public final class ValueHelper {
    public static final Pattern PATTERN = Pattern.compile("^/([^/]+)/?(.+)?$");

    public static String getPropertyKey(String valueKey) {
        if (valueKey.contains(":")) {
            return valueKey.substring(0, valueKey.indexOf(":"));
        }
        if (valueKey.startsWith("/")) {
            return valueKey.substring(valueKey.lastIndexOf("/") + 1);
        }
        return valueKey;
    }

    public static Object getObjectValue(String valueKey, Object obj) {
        int indexOf = valueKey.indexOf(":");
        if (indexOf != -1) {
            valueKey = valueKey.substring(indexOf + 1);
        }
        if (valueKey.equals("/")) {
            return obj;
        }
        JsonObject json = JsonUtils.asJsonObject(obj);
        if (valueKey.startsWith("/")) {
            return ValueHelper.getObjectFromJsonPointer(json, valueKey);
        }
        return json.getValue(valueKey);
    }

    private static Object getObjectFromJsonPointer(Object obj, String jsonKey) {
        if (!jsonKey.contains("[]")) {
            JsonPointer ptr = JsonPointer.from((String)jsonKey);
            return ptr.queryJson((Object)obj);
        }
        Object result = obj;
        String[] array = jsonKey.split("/");
        for (int i = 0; i < array.length; ++i) {
            String item = array[i];
            if ("".equals(item)) continue;
            if (item.endsWith("[]")) {
                String key = item.substring(0, item.length() - 2);
                Object tmp = ((JsonObject)result).getValue(key);
                if (tmp == null) {
                    return null;
                }
                if (tmp instanceof JsonArray) {
                    result = new ArrayList();
                    String newKey = ValueHelper.keyFor(array, i + 1);
                    for (Object a : (JsonArray)tmp) {
                        ((List)result).add(ValueHelper.getObjectFromJsonPointer(a, newKey));
                    }
                    break;
                }
                throw new GremlinException("Value with key: '" + key + "' should be JsonArray");
            }
            if (result instanceof JsonObject) {
                result = ((JsonObject)result).getValue(item);
            } else if (result instanceof JsonArray && item.matches("\\d+")) {
                JsonArray r = (JsonArray)result;
                int index = Integer.parseInt(item);
                result = index < r.size() ? r.getValue(index) : null;
            } else {
                result = null;
            }
            if (result != null) continue;
            return null;
        }
        return result;
    }

    private static String keyFor(String[] array, int pos) {
        StringBuilder builder = new StringBuilder();
        for (int i = pos; i < array.length; ++i) {
            builder.append("/").append(array[i]);
        }
        return builder.toString();
    }
}

