/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.FalloutDto;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDumpSupport;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.JsonUtils;

public class GraphMetaInfoSupport {
    public static final String UNKNOWN = "unknown";
    public static final String META = "meta";
    public static final String ASSEMBLY = "assembly";
    public static final String SOURCES = "sourceGraphs";
    public static final String SOURCES_DROPPED = "sourcesDropped";
    public static final String DROPPED_REPORT_ORIGIN = "reportOrigin";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String FILE_NAME = "fileName";
    public static final String VERSION = "version";
    public static final String INVENTORY_TOOL_VERSION = "aditVersion";
    public static final String TYPE_APPLICATION = "application";
    public static final String TYPE_COMPONENT = "component";
    public static final String TYPE_NAMESPACE = "namespace";
    public static final JsonPointer srcGraphsPtr = JsonPointer.from((String)"/assembly/sourceGraphs");
    public static final JsonPointer srcGraphsDroppedPtr = JsonPointer.from((String)"/assembly/sourcesDropped");

    public static List<FalloutDto> getFalloutReportFromDump(JsonObject dump) {
        if (!GraphDumpSupport.isGraphDumpSupported(dump)) {
            throw new IllegalArgumentException("Graph dump version is not supported: " + GraphDumpSupport.getGraphModelVersion(dump));
        }
        JsonArray array = (JsonArray)JsonPointer.from((String)"/graph/root/assembly/sourcesDropped").queryJson((Object)dump);
        if (array == null) {
            return Collections.emptyList();
        }
        JsonObject meta = (JsonObject)JsonPointer.from((String)"/graph/root/meta").queryJson((Object)dump);
        List<FalloutDto> list = array.stream().map(item -> GraphMetaInfoSupport.getFalloutItem(item, meta)).collect(Collectors.toList());
        return list;
    }

    public static FalloutDto getFalloutItem(Object item, JsonObject meta) {
        String msName;
        String appVersion;
        String appName;
        JsonObject src = JsonUtils.asJsonObject(item);
        switch (src.getString(TYPE, UNKNOWN)) {
            case "component": {
                Object o = JsonPointer.from((String)"/reportOrigin/name").queryJson((Object)src);
                if (o == null && meta != null && TYPE_APPLICATION.equals(meta.getValue(TYPE))) {
                    o = meta.getValue(NAME);
                }
                appName = o != null ? o.toString() : UNKNOWN;
                o = JsonPointer.from((String)"/reportOrigin/version").queryJson((Object)src);
                if (o == null && meta != null && TYPE_APPLICATION.equals(meta.getValue(TYPE))) {
                    o = meta.getValue(VERSION);
                }
                appVersion = o != null ? o.toString() : UNKNOWN;
                msName = src.getString(NAME, UNKNOWN);
                break;
            }
            case "application": {
                appName = src.getString(NAME, UNKNOWN);
                appVersion = src.getString(VERSION, UNKNOWN);
                msName = UNKNOWN;
                break;
            }
            default: {
                appName = src.getString(NAME, UNKNOWN);
                appVersion = src.getString(VERSION, UNKNOWN);
                msName = UNKNOWN;
            }
        }
        return new FalloutDto(appName, appVersion, msName);
    }

    public static String getInventoryToolVersion() {
        return (String)ConfigUtils.getInventoryToolBuildProperties().get("inventory.tool.version");
    }

    public static JsonObject initMetaInfoForComponent(Graph graph, String compName, String compVersion) {
        JsonObject meta = GraphMetaInfoSupport.getMetaInfoForComponent(compName, compVersion);
        graph.getVertex("root").put(META, (Object)meta);
        return meta;
    }

    public static JsonObject getMetaInfoForComponent(String compName, String compVersion) {
        if (StringUtils.isEmpty((CharSequence)compVersion)) {
            compVersion = UNKNOWN;
        }
        JsonObject meta = new JsonObject().put(TYPE, (Object)TYPE_COMPONENT).put(NAME, (Object)compName).put(VERSION, (Object)compVersion).put(INVENTORY_TOOL_VERSION, (Object)GraphMetaInfoSupport.getInventoryToolVersion());
        return meta;
    }

    public static final JsonObject initMetaInfoForApplication(Graph graph, String appName, String appVersion) {
        JsonObject meta = GraphMetaInfoSupport.getMetaInfoForApplication(appName, appVersion);
        graph.getVertex("root").put(META, (Object)meta);
        return meta;
    }

    public static final JsonObject getMetaInfoForApplication(String appName, String appVersion) {
        if (StringUtils.isEmpty((CharSequence)appVersion)) {
            appVersion = UNKNOWN;
        }
        JsonObject meta = new JsonObject().put(TYPE, (Object)TYPE_APPLICATION).put(NAME, (Object)appName).put(VERSION, (Object)appVersion).put(INVENTORY_TOOL_VERSION, (Object)GraphMetaInfoSupport.getInventoryToolVersion());
        return meta;
    }

    public static void initMetaInfoFromDesc(Graph graph, JsonObject graphDesc) {
        GraphMetaInfoSupport.enrichGraphDesc(graph, graphDesc);
        JsonObject targetRoot = graph.getVertex("root");
        JsonObject meta = JsonUtils.getOrCreateJsonObject(targetRoot, META);
        JsonUtils.copyValueIfNotNull(graphDesc, meta, TYPE);
        JsonUtils.copyValueIfNotNull(graphDesc, meta, NAME);
        JsonUtils.copyValueIfNotNull(graphDesc, meta, VERSION);
        meta.put(INVENTORY_TOOL_VERSION, (Object)GraphMetaInfoSupport.getInventoryToolVersion());
        JsonObject assembly = JsonUtils.getOrCreateJsonObject(targetRoot, ASSEMBLY);
        JsonUtils.getOrCreateJsonArray(assembly, SOURCES);
        JsonUtils.getOrCreateJsonArray(assembly, SOURCES_DROPPED);
    }

    public static void enrichGraphDesc(Graph graph, JsonObject graphDesc) {
        JsonObject graphMeta = graph.getVertex("root").getJsonObject(META);
        JsonUtils.copyValueIfAbsent(graphMeta, graphDesc, TYPE);
        JsonUtils.copyValueIfAbsent(graphMeta, graphDesc, NAME);
        JsonUtils.copyValueIfAbsent(graphMeta, graphDesc, VERSION);
        JsonUtils.copyValueIfAbsent(graphMeta, graphDesc, INVENTORY_TOOL_VERSION);
        if (graphDesc.getString(TYPE) == null) {
            if (graphDesc.getString(FILE_NAME) != null) {
                graphDesc.put(TYPE, (Object)TYPE_COMPONENT);
            } else {
                graphDesc.put(TYPE, (Object)UNKNOWN);
            }
        }
        if (graphDesc.getBoolean("isApplication", Boolean.valueOf(false)).booleanValue()) {
            graphDesc.put(TYPE, (Object)TYPE_APPLICATION).put(NAME, (Object)graphDesc.getString("appName"));
            String appVersion = graphDesc.getString("appVersion");
            if (StringUtils.isEmpty((CharSequence)appVersion) && StringUtils.isEmpty((CharSequence)(appVersion = graphDesc.getString(VERSION)))) {
                appVersion = UNKNOWN;
            }
            graphDesc.put(VERSION, (Object)appVersion);
        } else if (graphDesc.getBoolean("isNameSpace", Boolean.valueOf(false)).booleanValue()) {
            graphDesc.put(TYPE, (Object)TYPE_NAMESPACE).put(NAME, (Object)graphDesc.getString("nameSpaceName"));
        }
    }

    public static void addDroppedItem(InvalidGraphException e, JsonObject sourceDesc, Graph targetGraph) {
        JsonObject errorReport = new JsonObject();
        errorReport.put("reason", (Object)e.getReason());
        JsonUtils.copyValueIfNotNull(sourceDesc, errorReport, FILE_NAME);
        JsonUtils.copyValueIfNotNull(sourceDesc, errorReport, TYPE);
        JsonUtils.copyValueIfNotNull(sourceDesc, errorReport, NAME);
        JsonUtils.copyValueIfNotNull(sourceDesc, errorReport, VERSION);
        JsonUtils.copyValueIfNotNull(sourceDesc, errorReport, INVENTORY_TOOL_VERSION);
        JsonUtils.copyValueIfNotNull(sourceDesc, errorReport, ASSEMBLY);
        JsonObject targetRoot = targetGraph.getVertex("root");
        ((JsonArray)srcGraphsDroppedPtr.queryJson((Object)targetRoot)).add((Object)errorReport);
    }

    public static void mergeAssemblyInfo(JsonObject sourceRoot, JsonObject sourceDesc, JsonObject targetRoot, JsonObject targetDesc) {
        JsonArray sourceFallout;
        JsonObject sourceMetaInfo = GraphMetaInfoSupport.copyDescToInfo(sourceDesc);
        JsonObject sourceRootMeta = sourceRoot.getJsonObject(ASSEMBLY);
        if (sourceRootMeta != null) {
            sourceMetaInfo.put(ASSEMBLY, (Object)sourceRootMeta.copy());
        }
        JsonUtils.copyValueIfAbsent(sourceRootMeta, targetDesc, INVENTORY_TOOL_VERSION);
        JsonArray sourcesList = JsonUtils.getOrCreateJsonArray(targetRoot, srcGraphsPtr);
        sourcesList.add((Object)sourceMetaInfo);
        JsonArray jsonArray = sourceFallout = sourceRootMeta != null ? sourceRootMeta.getJsonArray(SOURCES_DROPPED) : null;
        if (sourceFallout != null) {
            for (Object obj : sourceFallout) {
                JsonObject jsonFallout = JsonUtils.asJsonObject(obj);
                JsonObject errorReport = jsonFallout.copy();
                errorReport.put(DROPPED_REPORT_ORIGIN, (Object)GraphMetaInfoSupport.copyDescToInfo(sourceDesc));
                ((JsonArray)srcGraphsDroppedPtr.queryJson((Object)targetRoot)).add((Object)errorReport);
            }
        }
    }

    public static JsonObject copyDescToInfo(JsonObject graphDesc) {
        JsonObject metaInfo = new JsonObject();
        JsonUtils.copyValueIfNotNull(graphDesc, metaInfo, TYPE);
        JsonUtils.copyValueIfNotNull(graphDesc, metaInfo, NAME);
        JsonUtils.copyValueIfNotNull(graphDesc, metaInfo, VERSION);
        JsonUtils.copyValueIfNotNull(graphDesc, metaInfo, FILE_NAME);
        JsonUtils.copyValueIfNotNull(graphDesc, metaInfo, INVENTORY_TOOL_VERSION);
        return metaInfo;
    }
}

