/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.matchers;

import com.google.inject.Inject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.Set;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.processor.matchers.MockFieldExtractor;
import org.qubership.itool.modules.processor.matchers.VertexMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceMocksMatcher
implements VertexMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceMocksMatcher.class);
    private final MockFieldExtractor mockFieldExtractor;

    @Inject
    public SourceMocksMatcher(MockFieldExtractor mockFieldExtractor) {
        this.mockFieldExtractor = mockFieldExtractor;
    }

    @Override
    public JsonObject findExistingVertex(Graph sourceGraph, JsonObject newVertex, Graph targetGraph) {
        if (!Boolean.TRUE.equals(newVertex.getValue("isMock"))) {
            return null;
        }
        Set<String> mockedForSet = this.mockFieldExtractor.getMockedForSet(sourceGraph, newVertex);
        if (mockedForSet.isEmpty()) {
            return null;
        }
        GraphTraversal<JsonObject, JsonObject> query = targetGraph.traversal().V(new String[0]).has("isMock", P.eq(false));
        for (String mockedFor : mockedForSet) {
            query = query.has(mockedFor, P.containing(JsonPointer.from((String)mockedFor).queryJson((Object)newVertex)));
        }
        JsonObject result = (JsonObject)query.next();
        if (result != null) {
            LOGGER.debug("Match found! keysToMatch={}, oldVertex={}, newVertex={}", new Object[]{mockedForSet, result.getString("id"), newVertex.getString("id")});
        }
        return result;
    }
}

