/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.matchers;

import com.google.inject.Inject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.processor.matchers.MockFieldExtractor;
import org.qubership.itool.modules.processor.matchers.VertexMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetMocksMatcher
implements VertexMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TargetMocksMatcher.class);
    private final MockFieldExtractor mockFieldExtractor;
    private List<VertexMatcher> compiledMatchers;

    @Inject
    public TargetMocksMatcher(MockFieldExtractor mockFieldExtractor) {
        this.mockFieldExtractor = mockFieldExtractor;
    }

    @Override
    public JsonObject findExistingVertex(Graph sourceGraph, JsonObject newVertex, Graph targetGraph) {
        if (this.compiledMatchers == null) {
            this.compiledMatchers = this.getMatchersForTargetGraph(targetGraph);
        }
        for (VertexMatcher matcher : this.compiledMatchers) {
            JsonObject existing = matcher.findExistingVertex(sourceGraph, newVertex, targetGraph);
            if (existing == null) continue;
            return existing;
        }
        return null;
    }

    private List<VertexMatcher> getMatchersForTargetGraph(Graph targetGraph) {
        List mocksInTarget = targetGraph.traversal().V(new String[0]).has("isMock", P.eq(true)).hasKey("mockedFor").toList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mocked vertices found: {}", (Object)mocksInTarget.stream().map(v -> v.getString("id")).collect(Collectors.joining(", ", "[", "]")));
        }
        return mocksInTarget.stream().map(mock -> this.createCorrelatorByExample(targetGraph, (JsonObject)mock)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private VertexMatcher createCorrelatorByExample(Graph targetGraph, JsonObject mock) {
        List mockPtrs = this.mockFieldExtractor.getMockedForSet(targetGraph, mock).stream().map(JsonPointer::from).collect(Collectors.toList());
        if (mockPtrs.isEmpty()) {
            return null;
        }
        return (srcGraph, newVertex, tgtGraph) -> {
            for (JsonPointer ptr : mockPtrs) {
                Object realVertexValue = ptr.queryJson((Object)newVertex);
                Object mockedVertexValue = ptr.queryJson((Object)mock);
                if (!(realVertexValue instanceof JsonArray ? !((JsonArray)realVertexValue).contains(mockedVertexValue) : !Objects.equals(mockedVertexValue, realVertexValue))) continue;
                return null;
            }
            LOG.debug("Match found! keysToMatch={}, oldVertex={}, newVertex={}", new Object[]{mockPtrs, mock.getString("id"), newVertex.getString("id")});
            return mock;
        };
    }
}

