/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAppVertexTask
implements GraphProcessorTask {
    private static final Logger LOG = LoggerFactory.getLogger(CreateAppVertexTask.class);
    protected final String appName;
    protected final String appVersion;
    protected boolean disabled;

    public CreateAppVertexTask(String appName, String appVersion) {
        if (StringUtils.isEmpty((CharSequence)appVersion)) {
            appVersion = "unknown";
        }
        this.appName = appName;
        this.appVersion = appVersion;
    }

    public CreateAppVertexTask(JsonObject desc) {
        this(desc.getString("appName"), desc.getString("appVersion"));
        if (!desc.getBoolean("isApplication", Boolean.valueOf(false)).booleanValue()) {
            LOG.debug("Target is not an application: {}", (Object)desc);
            this.disabled = true;
        }
    }

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        if (this.disabled) {
            LOG.info("Skipping task");
            return;
        }
        long startTime = System.nanoTime();
        LOG.info("Starting task");
        List existingApps = graph.traversal().V(new String[0]).hasType("application").toList();
        for (JsonObject existingApp : existingApps) {
            LOG.warn("Source graph already contain app vertex {} when trying to assemble an app graph: {}:{}", new Object[]{existingApp.getValue("id"), this.appName, this.appVersion});
        }
        String appVertexId = String.join((CharSequence)":", "application", this.appName, this.appVersion);
        LOG.info("Creating app vertex: {}", (Object)appVertexId);
        JsonObject applicationVertex = new JsonObject().put("id", (Object)appVertexId).put("name", (Object)this.appName).put("type", (Object)"application").put("version", (Object)this.appVersion);
        graph.addEdge(graph.getVertex("root"), applicationVertex);
        List outGoingVertices = graph.traversal().V(new String[0]).hasType("domain").out(new String[0]).toList();
        for (JsonObject outGoingVertex : outGoingVertices) {
            LOG.debug("Linking app {} to component {}", (Object)appVertexId, (Object)outGoingVertex.getString("id"));
            graph.addEdge(applicationVertex, outGoingVertex);
        }
        long endTime = System.nanoTime();
        LOG.info("Task completed in {}", (Object)Duration.ofNanos(endTime - startTime));
    }
}

