/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTransitiveHttpDependenciesTask
implements GraphProcessorTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTransitiveHttpDependenciesTask.class);

    @Override
    public void process(Graph graph) {
        long startTime = System.nanoTime();
        LOGGER.info("Starting task");
        List libToHttpDeps = graph.traversal().V(new String[0]).hasType("domain").out(new String[0]).as("COMP", new String[0]).out("library").as("LIB", new String[0]).outE("mandatory", "optional", "startup").as("E", new String[0]).inV().as("DEP", new String[0]).has("id", P.neq(__.select("COMP").id())).select("COMP", "LIB", "E", "DEP").toList();
        for (Map tuple : libToHttpDeps) {
            JsonObject from = (JsonObject)tuple.get("COMP");
            JsonObject depEdge = (JsonObject)tuple.get("E");
            String depType = depEdge.getString("type");
            JsonObject dependency = (JsonObject)tuple.get("DEP");
            List<JsonObject> connectingEdges = graph.getEdgesBetween(from, dependency);
            if (!connectingEdges.stream().noneMatch(edge -> edge.getString("type").equals(depType))) continue;
            JsonObject newEdge = new JsonObject().put("type", (Object)depType).put("reference", (Object)"transitive").put("source", (Object)((JsonObject)tuple.get("LIB")).getString("id"));
            LOGGER.debug("Adding transitive HTTP dependency: from={}, to={}, edge={}", new Object[]{from.getString("id"), dependency.getString("id"), newEdge});
            graph.addEdge(from, dependency, newEdge);
        }
        long endTime = System.nanoTime();
        LOGGER.info("Task completed in {}", (Object)Duration.ofNanos(endTime - startTime));
    }
}

