/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTransitiveQueueDependenciesTask
implements GraphProcessorTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTransitiveQueueDependenciesTask.class);

    @Override
    public void process(Graph graph) {
        long startTime = System.nanoTime();
        LOGGER.info("Starting task");
        List transitiveConsumers = graph.traversal().V("Infra").out(new String[0]).hasType("mq").as("MQ", new String[0]).outE("consumer").as("QE", new String[0]).inV().as("C1", new String[0]).in("library").as("C2", new String[0]).select("MQ", "QE", "C1", "C2").toList();
        for (Object tuple : transitiveConsumers) {
            JsonObject mq = (JsonObject)tuple.get("MQ");
            JsonObject queueEdge = (JsonObject)tuple.get("QE");
            String queueName = queueEdge.getString("name");
            JsonObject transitiveConsumer = (JsonObject)tuple.get("C2");
            List<JsonObject> connectingEdges = graph.getEdgesBetween(mq, transitiveConsumer);
            if (!connectingEdges.stream().noneMatch(edge -> edge.getString("type").equals("consumer") && edge.getString("name").equals(queueName))) continue;
            JsonObject newEdge = new JsonObject().put("type", (Object)"consumer").put("name", (Object)queueName).put("reference", (Object)"transitive").put("source", (Object)((JsonObject)tuple.get("C1")).getString("id"));
            LOGGER.debug("Adding transitive MQ dependency: from={}, to={}, edge={}", new Object[]{mq.getString("id"), transitiveConsumer.getString("id"), newEdge});
            graph.addEdge(mq, transitiveConsumer, newEdge);
        }
        List transitiveProducers = graph.traversal().V("Infra").out(new String[0]).hasType("mq").as("MQ", new String[0]).inE("producer").as("QE", new String[0]).outV().as("C1", new String[0]).in("library").as("C2", new String[0]).select("MQ", "QE", "C1", "C2").toList();
        for (Map tuple : transitiveProducers) {
            JsonObject mq = (JsonObject)tuple.get("MQ");
            JsonObject queueEdge = (JsonObject)tuple.get("QE");
            String queueName = queueEdge.getString("name");
            JsonObject transitiveProducer = (JsonObject)tuple.get("C2");
            List<JsonObject> connectingEdges = graph.getEdgesBetween(transitiveProducer, mq);
            if (!connectingEdges.stream().noneMatch(edge -> edge.getString("type").equals("producer") && edge.getString("name").equals(queueName))) continue;
            JsonObject newEdge = new JsonObject().put("type", (Object)"producer").put("name", (Object)queueName).put("reference", (Object)"transitive").put("source", (Object)((JsonObject)tuple.get("C1")).getString("id"));
            LOGGER.debug("Adding transitive MQ dependency: from={}, to={}, edge={}", new Object[]{transitiveProducer.getString("id"), mq.getString("id"), newEdge});
            graph.addEdge(transitiveProducer, mq, newEdge);
        }
        long endTime = System.nanoTime();
        LOGGER.info("Task completed in {}", (Object)Duration.ofNanos(endTime - startTime));
    }
}

