/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.utils.GraphHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchIsMicroserviceFieldTask
implements GraphProcessorTask {
    private static final Logger LOG = LoggerFactory.getLogger(PatchIsMicroserviceFieldTask.class);

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        if (graph.getGraphVersion() >= 3) {
            LOG.debug("Skipping task {}, because graph with version {} should have correct isMicroservice fields in components", (Object)this.getClass().getSimpleName(), (Object)graph.getGraphVersion());
            return;
        }
        long startTime = System.nanoTime();
        LOG.debug("Starting task {}", (Object)this.getClass().getSimpleName());
        List existingComponents = graph.traversal().V("root").out(new String[0]).hasType("domain").out(new String[0]).toList();
        for (JsonObject component : existingComponents) {
            if (component.getBoolean("isMicroservice") != null) continue;
            component.put("isMicroservice", (Object)GraphHelper.isComponentAMicroservice(graph, component));
        }
        long endTime = System.nanoTime();
        LOG.debug("Task completed in {} ", (Object)Duration.ofNanos(endTime - startTime));
    }
}

