/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchLanguagesNormalizationTask
implements GraphProcessorTask {
    private static final Logger LOG = LoggerFactory.getLogger(PatchLanguagesNormalizationTask.class);
    private static final JsonPointer LANGUAGE_SOURCE_VERSION_POINTER = JsonPointer.from((String)"/version/source");
    private static final JsonPointer LANGUAGE_TARGET_VERSION_POINTER = JsonPointer.from((String)"/version/target");

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        if (graph.getGraphVersion() >= 3) {
            LOG.debug("Skipping task {}, because graph with version {} should have correct language model", (Object)this.getClass().getSimpleName(), (Object)graph.getGraphVersion());
            return;
        }
        long startTime = System.nanoTime();
        LOG.debug("Starting task {}", (Object)this.getClass().getSimpleName());
        List existingComponents = graph.traversal().V("root").out(new String[0]).hasType("domain").out(new String[0]).toList();
        for (Object component : existingComponents) {
            this.convertDetailsLanguagesProperties(graph, (JsonObject)component);
            LanguageUtils.updateDetailsLanguagesUsingPomFile(graph, (JsonObject)component);
        }
        List languageVertices = graph.traversal().V("root").out(new String[0]).hasType("domain").out(new String[0]).as("C", new String[0]).out(new String[0]).hasType("language").as("L", new String[0]).select("C", "L").toList();
        for (Map languageEntry : languageVertices) {
            JsonObject languageVertex = PatchLanguagesNormalizationTask.enrichComponentLanguageUsages(languageEntry);
            graph.removeVertex(languageVertex);
        }
        for (JsonObject component : existingComponents) {
            LanguageUtils.buildLanguageVerticesWithEdges(graph, component);
        }
        long endTime = System.nanoTime();
        LOG.debug("Task completed in {} ", (Object)Duration.ofNanos(endTime - startTime));
    }

    private static JsonObject enrichComponentLanguageUsages(Map<String, JsonObject> languageEntry) {
        JsonObject component = languageEntry.get("C");
        List detailsLanguages = JsonUtils.asList(LanguageUtils.LANGUAGE_PATH_POINTER.queryJson((Object)component));
        JsonObject languageVertex = languageEntry.get("L");
        JsonObject languageVertexNameVersionJson = TechNormalizationHelper.normalizeTechAsJson(languageVertex.getString("name"));
        if (languageVertexNameVersionJson != null && "Java".equals(languageVertexNameVersionJson.getString("name"))) {
            String vertexSourceVersion = (String)LANGUAGE_SOURCE_VERSION_POINTER.queryJson((Object)languageVertex);
            String vertexTargetVersion = (String)LANGUAGE_TARGET_VERSION_POINTER.queryJson((Object)languageVertex);
            if (detailsLanguages == null) {
                detailsLanguages = JsonUtils.asList(LanguageUtils.convertListToLanguages(languageVertex.getString("name")));
                JsonObject detailsLanguage2 = (JsonObject)detailsLanguages.get(0);
                LanguageUtils.LANGUAGE_PATH_POINTER.writeJson((Object)component, (Object)new JsonArray(detailsLanguages), true);
                PatchLanguagesNormalizationTask.updateVersionUsage(vertexSourceVersion, vertexTargetVersion, detailsLanguage2);
            } else {
                detailsLanguages.stream().filter(detailsLanguage -> detailsLanguage.getJsonArray("usage") == null && detailsLanguage.getString("name").equals(languageVertexNameVersionJson.getString("name"))).forEach(detailsLanguage -> PatchLanguagesNormalizationTask.updateVersionUsage(vertexSourceVersion, vertexTargetVersion, detailsLanguage));
            }
        }
        return languageVertex;
    }

    private static void updateVersionUsage(String vertexSourceVersion, String vertexTargetVersion, JsonObject detailsLanguage) {
        String detailsLanguageVersion = detailsLanguage.getString("version");
        if (detailsLanguageVersion == null) {
            return;
        }
        if (detailsLanguageVersion.equals(vertexSourceVersion)) {
            LanguageUtils.updateVersionUsage("source", detailsLanguage);
        }
        if (detailsLanguageVersion.equals(vertexTargetVersion)) {
            LanguageUtils.updateVersionUsage("target", detailsLanguage);
        }
    }

    private void convertDetailsLanguagesProperties(Graph graph, JsonObject component) {
        Object languages = LanguageUtils.LANGUAGE_PATH_POINTER.queryJson((Object)component);
        JsonArray resultingList = new JsonArray();
        if (languages instanceof JsonArray || languages instanceof List) {
            List languageList = JsonUtils.asList(languages);
            for (Object languageObj : languageList) {
                try {
                    Map languageJson = JsonUtils.asMap(languageObj);
                    resultingList.add((Object)JsonObject.mapFrom(languageJson));
                }
                catch (ClassCastException classCastException) {
                    GraphReport report = graph.getReport();
                    report.addMessage("CONF_ERROR", component, classCastException.getMessage());
                }
            }
            if (languageList.size() != resultingList.size()) {
                LanguageUtils.LANGUAGE_PATH_POINTER.writeJson((Object)component, (Object)resultingList);
            } else {
                LOG.debug("{}: Language of the component has correct format already", (Object)component.getString("id"));
            }
        } else if (languages instanceof String) {
            resultingList = LanguageUtils.convertListToLanguages(languages);
            LanguageUtils.LANGUAGE_PATH_POINTER.writeJson((Object)component, (Object)resultingList);
        }
    }
}

