/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import com.google.inject.Inject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecreateDomainsStructureTask
implements GraphProcessorTask {
    private GraphReport graphReport;
    static final Logger LOG = LoggerFactory.getLogger(RecreateDomainsStructureTask.class);
    private static final String DOMAIN_RESOURCE_PATH = "classpath:/domains.json";

    @Inject
    public RecreateDomainsStructureTask(Provider<GraphReport> graphReportProvider) {
        this.graphReport = (GraphReport)graphReportProvider.get();
    }

    @Override
    public void process(Graph graph) throws InvalidGraphException {
        Map<String, JsonObject> domainsDataFromReference = this.readJsonResource(DOMAIN_RESOURCE_PATH);
        List domainsFromGraph = graph.traversal().V(new String[0]).hasType("domain").toList();
        for (JsonObject domainFromGraph : domainsFromGraph) {
            List components;
            String domainId = domainFromGraph.getString("id");
            JsonObject domainData = domainsDataFromReference.get(domainId);
            if ("orphans".equals(domainId)) {
                components = graph.traversal().V(domainId).out(new String[0]).toList();
                for (JsonObject sourceComponent : components) {
                    LOG.warn("Component '{}' belongs to pseudo-domain '{}'", (Object)sourceComponent.getString("id"), (Object)domainId);
                }
                continue;
            }
            if (domainData != null) {
                domainFromGraph.put("technical-manager", (Object)domainData.getString("technical-manager"));
                domainFromGraph.put("department", (Object)domainData.getString("department"));
                domainFromGraph.put("name", (Object)domainData.getString("name"));
                domainFromGraph.put("isMock", (Object)false);
                continue;
            }
            components = graph.traversal().V(domainId).out(new String[0]).toList();
            for (JsonObject sourceComponent : components) {
                this.graphReport.referenceNotFound(sourceComponent, domainId);
            }
        }
    }

    protected Map<String, JsonObject> readJsonResource(String resourcePath) {
        HashMap<String, JsonObject> domainDataMap = new HashMap<String, JsonObject>();
        try {
            JsonArray domains = JsonUtils.readJsonResource(this.getClass(), resourcePath, JsonArray.class);
            for (Object domain : domains) {
                JsonObject element = (JsonObject)domain;
                Object domainId = element.getString("id");
                domainId = ((String)domainId).startsWith("D_") ? domainId : "D_" + (String)domainId;
                element.put("id", domainId);
                domainDataMap.put((String)domainId, element);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read JSON resource file: " + e.getMessage(), e);
        }
        return domainDataMap;
    }
}

