/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.processor.tasks;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDataConstants;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.modules.report.GraphReportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecreateHttpDependenciesTask
implements GraphProcessorTask {
    static final Logger LOG = LoggerFactory.getLogger(RecreateHttpDependenciesTask.class);
    static final Pattern VALID_DNS_NAMES_PATTERN = Pattern.compile("^[-a-zA-Z0-9]+$");

    @Override
    public void process(Graph graph) {
        long startTime = System.nanoTime();
        LOG.info("Starting task");
        List<Map<Object, Object>> componentsWithRawDependencies = graph.traversal().V(new String[0]).hasType("domain").out(new String[0]).values("C:/", "startup:/details/dependencies/startup", "mandatory:/details/dependencies/mandatory", "optional:/details/dependencies/optional").toList();
        Set<String> requiredDnsNames = this.collectRequiredDnsNames(componentsWithRawDependencies);
        Map<String, JsonObject> dnsNameToComponentMap = this.findComponentVerticesByDnsNames(graph, requiredDnsNames);
        this.recreateMissingDependencyEdges(graph, componentsWithRawDependencies, dnsNameToComponentMap);
        long endTime = System.nanoTime();
        LOG.info("Task completed in {}", (Object)Duration.ofNanos(endTime - startTime));
    }

    private void recreateMissingDependencyEdges(Graph graph, List<Map<Object, Object>> componentsWithRawDependencies, Map<String, JsonObject> dnsNameToComp) {
        for (Map<Object, Object> item : componentsWithRawDependencies) {
            JsonObject component = (JsonObject)item.get("C");
            for (String dependencyType : GraphDataConstants.COMP_DEPENDENCY_TYPES.keySet()) {
                JsonArray dependencyDnsNames = RecreateHttpDependenciesTask.getJsonArray(item, dependencyType);
                if (dependencyDnsNames == null) continue;
                for (Object dnsName : dependencyDnsNames) {
                    JsonObject targetComponent;
                    if (GraphDataConstants.NOS_TO_RECOGNIZE.contains(dnsName) || !this.isEdgeMissing(graph, component, dependencyType, targetComponent = dnsNameToComp.computeIfAbsent((String)dnsName, newDnsName -> this.createMockByDnsName(graph, (String)newDnsName)))) continue;
                    JsonObject edge = new JsonObject().put("type", (Object)dependencyType).put("protocol", (Object)"http");
                    graph.addEdge(component, targetComponent, edge);
                    LOG.info("Edge recreated: from='{}', to='{}', edge='{}'", new Object[]{component.getString("id"), targetComponent.getString("id"), edge});
                }
            }
        }
    }

    private boolean isEdgeMissing(Graph graph, JsonObject component, String dependencyType, JsonObject targetComponent) {
        return graph.getVertex(targetComponent.getString("id")) == null || graph.getEdgesBetween(component, targetComponent).stream().noneMatch(edge -> dependencyType.equals(edge.getString("type")));
    }

    private Set<String> collectRequiredDnsNames(List<Map<Object, Object>> componentsWithRawDependencies) {
        Set<String> requiredDnsNames = componentsWithRawDependencies.stream().flatMap(item -> RecreateHttpDependenciesTask.concatStreams(item)).collect(Collectors.toSet());
        requiredDnsNames.removeIf(dnsName -> dnsName == null || GraphDataConstants.NOS_TO_RECOGNIZE.contains(dnsName) || !VALID_DNS_NAMES_PATTERN.matcher((CharSequence)dnsName).matches());
        return requiredDnsNames;
    }

    private Map<String, JsonObject> findComponentVerticesByDnsNames(Graph graph, Set<String> requiredDnsNames) {
        HashMap<String, JsonObject> dnsNameToComp = new HashMap<String, JsonObject>();
        List componentsWithDnsNames = graph.traversal().V(new String[0]).hasKey("/details/dnsNames").as("C", new String[0]).values("dnsNames:/details/dnsNames").unfold().as("DN", new String[0]).select("C", "DN").has("DN", P.within(requiredDnsNames.toArray())).toList();
        for (Map entry : componentsWithDnsNames) {
            JsonObject component = (JsonObject)entry.get("C");
            String dnsName = (String)entry.get("DN");
            JsonObject oldComponent = dnsNameToComp.put(dnsName, component);
            GraphReport report = graph.getReport();
            if (oldComponent != null) {
                String msg = "Vertices '" + oldComponent.getString("id") + "' and '" + component.getString("id") + "' share the same dnsName '" + dnsName + "'";
                if (report != null) {
                    report.addMessage("CONF_ERROR", component, msg);
                } else {
                    LOG.error(msg);
                }
            }
            if (component.getBoolean("isMock", Boolean.valueOf(false)).booleanValue() || !(report instanceof GraphReportImpl)) continue;
            JsonArray records = ((GraphReportImpl)report).getRecords();
            this.removeOutdatedReportRecords(component, dnsName, records);
        }
        return dnsNameToComp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOutdatedReportRecords(JsonObject comp, String dnsName, JsonArray reportRecords) {
        Pattern pattern = Pattern.compile("^Reference was not found. Reference: \\w+ http dependency " + dnsName + "$");
        JsonArray jsonArray = reportRecords;
        synchronized (jsonArray) {
            Iterator it = reportRecords.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof JsonObject)) continue;
                JsonObject record = (JsonObject)o;
                String message = record.getString("message");
                boolean matchingErrorFound = "CONF_ERROR".equals(record.getString("type")) && message != null && message.startsWith("Reference was not found. Reference:") && pattern.matcher(message).matches();
                if (!matchingErrorFound) continue;
                it.remove();
                LOG.info("Dependency on dnsName {} from {} has been restored to {}. Report message removed: '{}'", new Object[]{dnsName, record.getString("component"), comp.getString("id"), message});
            }
        }
    }

    JsonObject createMockByDnsName(Graph graph, String dnsName) {
        String mockId = "mock:dnsName:" + dnsName;
        LOG.info("Mock vertex '{}' recreated to substitute dnsName '{}'", (Object)mockId, (Object)dnsName);
        JsonObject mockVertex = new JsonObject().put("id", (Object)mockId).put("type", (Object)"unknown").put("name", (Object)dnsName).put("isMock", (Object)true).put("mockedFor", (Object)new JsonArray().add((Object)"/details/dnsNames")).put("details", (Object)new JsonObject().put("dnsName", (Object)dnsName).put("dnsNames", (Object)dnsName));
        graph.addVertex(mockVertex);
        return mockVertex;
    }

    static Stream<String> concatStreams(Map<Object, Object> item) {
        Stream<String> newStream = Stream.empty();
        for (String depType : GraphDataConstants.COMP_DEPENDENCY_TYPES.keySet()) {
            JsonArray asArray = RecreateHttpDependenciesTask.getJsonArray(item, depType);
            if (asArray == null) continue;
            newStream = Stream.concat(newStream, asArray.stream());
        }
        return newStream;
    }

    static JsonArray getJsonArray(Map<Object, Object> item, String key) {
        Object value = item.get(key);
        if (value instanceof List) {
            return new JsonArray((List)value);
        }
        if (value instanceof JsonArray) {
            return (JsonArray)value;
        }
        return null;
    }
}

