/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.template;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.modules.template.DiagramDomainMethod;
import org.qubership.itool.modules.template.DiagramGeneralDomainMethod;
import org.qubership.itool.modules.template.DiagramMicroserviceMethod;
import org.qubership.itool.modules.template.DiagramQueueMethod;
import org.qubership.itool.modules.template.JsonObjectWrapper;
import org.qubership.itool.modules.template.TemplateService;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateServiceImpl
implements TemplateService {
    protected Logger LOG = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private DiagramService diagramService;
    private Configuration configuration;
    private JsonObject appConfig;

    public TemplateServiceImpl(DiagramService diagramService, JsonObject config) {
        this.diagramService = diagramService;
        this.appConfig = config;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            try {
                this.configuration = this.configure();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.configuration;
    }

    @Override
    public Configuration configure() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setDirectoryForTemplateLoading(new File("."));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setTagSyntax(2);
        cfg.setInterpolationSyntax(22);
        cfg.setObjectWrapper((ObjectWrapper)new JsonObjectWrapper(cfg.getIncompatibleImprovements()));
        cfg.setSharedVariable("diagramMicroservice", (TemplateModel)new DiagramMicroserviceMethod(this.diagramService));
        cfg.setSharedVariable("diagramGeneralDomain", (TemplateModel)new DiagramGeneralDomainMethod(this.diagramService));
        cfg.setSharedVariable("diagramDomain", (TemplateModel)new DiagramDomainMethod(this.diagramService));
        cfg.setSharedVariable("diagramQueue", (TemplateModel)new DiagramQueueMethod(this.diagramService));
        cfg.addAutoImport("md", ConfigUtils.getConfigFilePath(this.appConfig, "config/templates2", "macro", "markdown.ftlh").toString());
        return cfg;
    }

    @Override
    public Template getTemplate(String templateName) {
        Template template = null;
        try {
            template = this.getConfiguration().getTemplate(ConfigUtils.getConfigFilePath(this.appConfig, "config/templates2", templateName).toString().replaceAll("\\\\", "/"));
        }
        catch (IOException e) {
            this.getLogger().error("Freemarker error", (Throwable)e);
        }
        return template;
    }

    @Override
    public String processTemplate(ConfluencePage confluencePage) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        this.getTemplate(confluencePage.getTemplate()).process(confluencePage.getDataModel(), (Writer)writer);
        return writer.toString();
    }

    @Override
    public DiagramService getDiagramService() {
        return this.diagramService;
    }

    protected Logger getLogger() {
        return this.LOG;
    }
}

