/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.ci;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.nio.file.Path;
import javax.annotation.Resource;
import org.qubership.itool.modules.processor.MergerApi;
import org.qubership.itool.tasks.FlowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeGraphsVerticle
extends FlowTask {
    protected static Logger LOGGER = LoggerFactory.getLogger(MergeGraphsVerticle.class);
    @Resource
    private Provider<MergerApi> graphMergerProvider;

    @Override
    protected String[] features() {
        return new String[]{"unskippable"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        this.vertx.executeBlocking(promise -> {
            try (MergerApi merger = (MergerApi)this.graphMergerProvider.get();){
                JsonObject targetDesc = new JsonObject().put("isApplication", (Object)true).put("appName", (Object)this.config().getString("ciAppName", "unknown")).put("appVersion", (Object)this.config().getString("ciAppVersion", "unknown"));
                merger.prepareGraphForMerging(this.graph, targetDesc);
                merger.walkAndMerge(Path.of(this.config().getString("ciInputDirectory"), new String[0]), this.graph, targetDesc);
                merger.finalizeGraphAfterMerging(this.graph, targetDesc);
            }
            catch (Exception e) {
                this.report.exceptionThrown(new JsonObject().put("id", (Object)"inventory-tool"), e);
            }
            finally {
                promise.tryComplete();
            }
        }, res -> this.taskCompleted(taskPromise));
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

