/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.ci;

import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelocateComponentsVerticle
extends FlowTask {
    protected Logger LOGGER = LoggerFactory.getLogger(RelocateComponentsVerticle.class);

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        Graph graph = this.graph;
        String mockDomainId = this.config().getString("ciMockDomain");
        JsonObject mockDomain = (JsonObject)this.V(mockDomainId).next();
        List components = this.V(mockDomainId).out(new String[0]).toList();
        for (JsonObject comp : components) {
            String name;
            JsonObject newDomain;
            boolean needRelocate;
            JsonObject newComponent;
            boolean needRename;
            String compId = comp.getString("id");
            JsonObject details = comp.getJsonObject("details");
            String newComponentId = details.getString("abbreviation");
            boolean bl = needRename = StringUtils.isNotBlank((CharSequence)newComponentId) && !newComponentId.equals(compId);
            if (needRename) {
                this.getLogger().info("Changing component id from '{}' to '{}'", (Object)compId, (Object)newComponentId);
                newComponent = new JsonObject();
                newComponent.put("id", (Object)newComponentId);
                newComponent.getMap().putAll(comp.getMap());
                newComponent.put("id", (Object)newComponentId);
                newComponent.put("isMock", (Object)false);
                graph.addVertex(newComponent);
            } else {
                comp.put("isMock", (Object)false);
                newComponentId = compId;
                newComponent = comp;
            }
            String newDomainId = details.getString("domainFromInventory");
            boolean bl2 = needRelocate = StringUtils.isNotBlank((CharSequence)newDomainId) && !newDomainId.equals(mockDomainId);
            if (needRelocate) {
                newDomainId = ConfigUtils.fillDomainId(newDomainId);
                this.getLogger().info("Relocating component '{}' from domain '{}' to '{}'", new Object[]{newComponentId, mockDomainId, newDomainId});
                newDomain = (JsonObject)this.V(newDomainId).next();
                if (newDomain == null) {
                    newDomain = new JsonObject().put("id", (Object)newDomainId).put("type", (Object)"domain").put("department", (Object)"unknown").put("isMock", (Object)true);
                    graph.addVertexUnderRoot(newDomain);
                }
            } else {
                newDomainId = mockDomainId;
                newDomain = mockDomain;
            }
            if (StringUtils.isBlank((CharSequence)(name = details.getString("name")))) {
                details.put("name", this.config().getValue("ciRunName"));
            }
            if (!needRename && !needRelocate) continue;
            JsonPointer.from((String)"/details/domain").writeJson((Object)newComponent, (Object)newDomainId);
            graph.addEdge(newDomain, newComponent);
            if (needRelocate) {
                graph.removeAllEdges(mockDomain, comp);
            }
            if (!needRename) continue;
            this.relocateEdges(comp, newComponent);
            graph.removeVertex(comp);
        }
        List remainingComponents = this.V(mockDomainId).out(new String[0]).toList();
        if (remainingComponents.isEmpty()) {
            this.getLogger().info("Mock domain {} is now empty, removing it", (Object)mockDomainId);
            graph.removeVertex(mockDomain);
        } else {
            for (JsonObject comp : remainingComponents) {
                this.report.referenceNotFound(comp, "domain");
            }
        }
        this.taskCompleted(taskPromise);
    }

    private void relocateEdges(JsonObject oldVertex, JsonObject newVertex) {
        List incoming = this.V(oldVertex.getString("id")).inE(new String[0]).as("E", new String[0]).outV().as("V", new String[0]).select("E", "V").toList();
        Graph graph = this.graph;
        for (Map in : incoming) {
            JsonObject newEdge = this.duplicateWithoutId((JsonObject)in.get("E"));
            graph.addEdge((JsonObject)in.get("V"), newVertex, newEdge);
        }
        List outgoing = this.V(oldVertex.getString("id")).outE(new String[0]).as("E", new String[0]).inV().as("V", new String[0]).select("E", "V").toList();
        for (Map out : outgoing) {
            JsonObject newEdge = this.duplicateWithoutId((JsonObject)out.get("E"));
            graph.addEdge(newVertex, (JsonObject)out.get("V"), newEdge);
        }
    }

    private JsonObject duplicateWithoutId(JsonObject object) {
        JsonObject newObj = new JsonObject();
        newObj.getMap().putAll(object.getMap());
        newObj.remove("id");
        return newObj;
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

