/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.modules.diagram.UMLDiagramEncoder;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.modules.template.TemplateService;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.JsonUtils;

public abstract class AbstractConfluenceGenerationPageVerticle
extends AbstractAggregationTaskVerticle {
    @Resource
    private TemplateService templateService;
    public static final String OUTPUT_CONFLUENCE = "output/confluence/";

    @Override
    protected String[] features() {
        return new String[]{"confluence2Generate"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        JsonArray rootConfluencePages = JsonUtils.getOrCreateJsonArray(this.graph.getVertex("root"), "confluencePages");
        this.vertx.executeBlocking(promise -> {
            List<ConfluencePage> pageList = this.prepareConfluencePageList();
            pageList.forEach(page -> {
                page.addDataModel("release", ConfigUtils.getConfigValue("/release", this.config()));
                page.setSpace(ConfigUtils.getConfigValue("/confluence/space", this.config()));
            });
            promise.complete(pageList);
        }, res -> {
            if (res.failed()) {
                this.report.internalError(ExceptionUtils.getStackTrace((Throwable)res.cause()));
                this.taskCompleted(taskPromise);
                return;
            }
            List confluencePageList = (List)res.result();
            if (confluencePageList == null) {
                this.taskCompleted(taskPromise);
                return;
            }
            ArrayList<Future> futureList = new ArrayList<Future>();
            for (ConfluencePage confluencePage : confluencePageList) {
                this.getLogger().info("Generate Confluence page: " + confluencePage.getDirectoryPath() + "/" + confluencePage.getFileName());
                Future future = Future.future(promise -> {
                    try {
                        String result = this.templateService.processTemplate(confluencePage);
                        if (result != null) {
                            File dir = new File(OUTPUT_CONFLUENCE + confluencePage.getDirectoryPath());
                            if (!dir.exists()) {
                                dir.mkdirs();
                            }
                            String path = dir.getPath() + "/" + confluencePage.getFileName() + ".confluence";
                            this.vertx.fileSystem().writeFileBlocking(path, Buffer.buffer((String)result));
                            JsonObject page = new JsonObject();
                            page.put("title", (Object)confluencePage.getTitle());
                            page.put("parentTitle", (Object)confluencePage.getParentTitle());
                            page.put("type", (Object)confluencePage.getType());
                            page.put("onDiskPath", (Object)path);
                            page.put("space", (Object)confluencePage.getSpace());
                            rootConfluencePages.add((Object)page);
                            this.getLogger().debug("Page '" + page.getString("title") + "' generation complete (" + page.getString("onDiskPath") + ")");
                        }
                        promise.complete();
                    }
                    catch (Exception ex) {
                        promise.fail((Throwable)ex);
                        JsonObject component = confluencePage.getElement();
                        this.report.exceptionThrown(component, ex);
                    }
                });
                futureList.add(future);
            }
            this.completeCompositeTask(futureList, taskPromise);
        });
    }

    protected List<ConfluencePage> prepareConfluencePageList() {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        List departments = this.V(new String[0]).hasType("domain").value("department").dedup().toList();
        for (String department : departments) {
            List<ConfluencePage> confluencePages = this.prepareConfluencePageList(department);
            for (ConfluencePage page : confluencePages) {
                page.addDataModel("department", department);
            }
            confluencePageList.addAll(confluencePages);
        }
        return confluencePageList;
    }

    protected String getPublicDomainId(String domainId) {
        return ConfigUtils.stripDomainId(domainId);
    }

    protected abstract List<ConfluencePage> prepareConfluencePageList(String var1);

    protected String buildDiagramImageURL(TemplateMethodModelEx diagramMethod, List<Object> arguments) {
        String generatedText = null;
        try {
            generatedText = (String)diagramMethod.exec(arguments);
        }
        catch (TemplateModelException e) {
            this.getLogger().error("Could not generate plantuml diagram. StackTrace : " + e.getMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)generatedText)) {
            Object encodedText = UMLDiagramEncoder.encodeDiagram(generatedText);
            JsonObject config = this.config();
            String plantumlURL = ConfigUtils.getConfigValue("/plantUMLUrl", config);
            encodedText = plantumlURL + (String)encodedText;
            return encodedText;
        }
        return null;
    }
}

