/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import jakarta.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.parser.OpenApi3Parser;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.gremlin2.structure.MapElement;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.modules.template.DiagramMicroserviceMethod;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.qubership.itool.utils.LanguageUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceGenerateComponentPagesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    @Resource
    protected DiagramService diagramService;
    @Resource
    protected Provider<ConfluencePage> confluencePageProvider;
    public static final List<String> BACKEND_TYPES = Arrays.asList("backend", "ui backend");
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceGenerateComponentPagesVerticle.class);

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        List components = this.V(new String[0]).hasType("domain").has("department", department).out(new String[0]).hasKeys("/details/domain").toList();
        for (JsonObject component : components) {
            String framework;
            String domain = (String)JsonPointer.from((String)"/details/domain").queryJson((Object)component);
            String componentId = component.getString("id");
            this.getLogger().info("Processing: {}", (Object)componentId);
            if (null == domain) {
                this.report.mandatoryValueMissed(component, "Domain name");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)component.getString("name"))) {
                this.report.mandatoryValueMissed(component, "Component name");
                continue;
            }
            String publicDomainId = this.getPublicDomainId(domain);
            String pageTitle = "Tech of " + publicDomainId + "." + component.getString("name");
            String parentTitle = "Tech of " + publicDomainId;
            ConfluencePage page = (ConfluencePage)this.confluencePageProvider.get();
            confluencePageList.add(page);
            page.setElement(component);
            page.setElementType("component");
            page.setTitle(pageTitle);
            page.setParentTitle(parentTitle);
            page.setType("component");
            page.setTemplate("componentPage.ftlh");
            page.setDirectoryPath(department + "/" + domain);
            page.setFileName(componentId);
            String languages = LanguageUtils.getLanguagesAsString(this.graph, component);
            if (!StringUtils.isEmpty((CharSequence)languages)) {
                page.addDataModel("language", languages);
            }
            if ((framework = (String)JsonPointer.from((String)"/details/framework").queryJson((Object)component)) != null && !framework.isEmpty()) {
                List<String> frameworks = Arrays.asList(framework.split("\\s*,\\s*"));
                page.addDataModel("framework", String.join((CharSequence)", ", TechNormalizationHelper.normalizeTechs(frameworks)));
            }
            List artifacts = this.V(componentId).out("module").order().by("id").toList();
            page.addDataModel("artifacts", artifacts);
            GraphTraversal<JsonObject, JsonObject> directTraversal = this.V(componentId).out("module").outE("dependency").has("transitive", P.neq(true)).has("scope", P.neq("test")).has("component", componentId).inV().dedup();
            List directDependencies = directTraversal.clone().order().by("id").toList();
            page.addDataModel("directDependencies", directDependencies);
            List transitiveDependencies = LanguageUtils.hasLanguage(this.graph, component, "GoLang") ? this.V(componentId).out("module").outE("dependency").has("transitive", P.eq(true)).has("component", componentId).inV().dedup().order().by("id").toList() : directTraversal.clone().outE("dependency").has("scope", P.neq("test")).has("component", componentId).inV().dedup().repeat(__.outE("dependency").has("scope", P.neq("test")).has("component", componentId).inV().dedup()).emit().dedup().order().by("id").toList();
            page.addDataModel("transitiveDependencies", transitiveDependencies);
            List groupIdDuplicated = directTraversal.clone().repeat(__.outE("dependency").has("scope", P.neq("test")).has("component", componentId).inV().dedup()).emit().dedup().values("groupId", "version").dedup().group().by("groupId").by("version").unfold().by(MapElement.both).where(__.value().size().is(P.gt(1))).order().by(MapElement.key).toList();
            page.addDataModel("groupIdDuplicated", groupIdDuplicated);
            this.addOpenApiSpecification(page, component);
            List outDependenciesList = this.V(componentId).outE(new String[0]).has("type", P.without("module", "info", "implemented")).type().as("type", new String[0]).inV().where(__.in(new String[0]).hasType("domain")).values("name", "id", "/details/domain", "/details/owner").as("component", new String[0]).select("component", "type").dedup().toList();
            page.addDataModel("outDependenciesList", outDependenciesList);
            List inDependenciesList = this.V(componentId).inE(new String[0]).has("type", P.without("module", "info", "implemented")).type().as("type", new String[0]).outV().where(__.in(new String[0]).hasType("domain")).values("name", "id", "/details/domain", "/details/owner").as("component", new String[0]).select("component", "type").dedup().toList();
            page.addDataModel("inDependenciesList", inDependenciesList);
            List supportedGatewayList = this.V(componentId).out(new String[0]).hasType("gateway").value("id").toList();
            if (CollectionUtils.isNotEmpty(supportedGatewayList)) {
                page.addDataModel("gateways", supportedGatewayList);
            }
            List directErrorCodes = this.V(componentId).out("errorCode").toList();
            page.addDataModel("directErrorCodes", directErrorCodes);
            List indirectErrorCodes = this.V(componentId).repeat(__.out("optional", "mandatory", "library").hasNotId(componentId).where(__.in(new String[0]).hasType("domain"))).emit().dedup().out("errorCode").toList();
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(department);
            arguments.add(domain);
            arguments.add(componentId);
            DiagramMicroserviceMethod diagramMicroserviceMethod = new DiagramMicroserviceMethod(this.diagramService);
            String encodedText = this.buildDiagramImageURL(diagramMicroserviceMethod, arguments);
            if (encodedText != null) {
                page.addDataModel("encodedDiagramMicroservice", encodedText);
            }
            page.addDataModel("indirectErrorCodes", indirectErrorCodes);
            page.addDataModel("totalErrorCodesCount", directErrorCodes.size() + indirectErrorCodes.size());
        }
        return confluencePageList;
    }

    private void addOpenApiSpecification(ConfluencePage page, JsonObject component) {
        if (!BACKEND_TYPES.contains(component.getString("type"))) {
            return;
        }
        String openApiSpecPath = component.getString("openApiSpecPath");
        if (openApiSpecPath == null) {
            return;
        }
        try {
            OpenApi3 parser = (OpenApi3)new OpenApi3Parser().parse(new File(openApiSpecPath), false);
            page.addDataModel("openApi", parser);
        }
        catch (ResolutionException | ValidationException e) {
            this.LOG.warn("Can't parse OpenApi spec for " + component.getString("id"));
            this.report.exceptionThrown(component, (Exception)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

