/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence;

import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.modules.template.DiagramDomainMethod;
import org.qubership.itool.modules.template.DiagramGeneralDomainMethod;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceGenerateDomainPagesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceGenerateDomainPagesVerticle.class);
    @Resource
    protected DiagramService diagramService;
    @Resource
    protected Provider<ConfluencePage> confluencePageProvider;

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        List domainIdList = this.V(new String[0]).hasType("domain").has("department", P.eq(department)).toList();
        for (JsonObject domain : domainIdList) {
            DiagramDomainMethod diagramDomainMethod;
            String domainId = domain.getString("id");
            ConfluencePage page = (ConfluencePage)this.confluencePageProvider.get();
            confluencePageList.add(page);
            page.setElement(domain);
            page.setElementType("domain");
            page.setTitle("Tech of " + this.getPublicDomainId(domainId));
            page.setParentTitle("Tech of cloud " + department);
            page.setType("domain");
            page.setTemplate("domainPage.ftlh");
            page.setDirectoryPath(department + "/" + domainId);
            page.setFileName("domainPage");
            List components = this.V(domainId).out(new String[0]).as("C", new String[0]).local(__.in(new String[0]).where(__.not(__.hasType("domain"))).count()).as("T", new String[0]).select("C", "T").toList();
            page.addDataModel("components", components);
            List techStack = this.V(domainId).out(new String[0]).out(new String[0]).where(__.in(new String[0]).hasId("Infra", "Info")).not(__.has("type", "gateway")).name().dedup().order().toList();
            page.addDataModel("techStack", techStack);
            List techStackByService = this.V(domainId).out(new String[0]).as("C", new String[0]).local(__.out(new String[0]).where(__.in(new String[0]).hasId("Infra", "Info")).not(__.has("type", "gateway")).name().dedup().fold()).as("T", new String[0]).select("C", "T").values("abbreviation:/C/details/abbreviation", "name:/C/name", "apiSpec:/C/details/api/apiSpecPublished", "usedTech:/T").order().by("name").toList();
            page.addDataModel("techStackByService", techStackByService);
            List tmfSpecList = this.V(domainId).out(new String[0]).as("C", new String[0]).out(new String[0]).where(__.in(new String[0]).hasId("Spec")).as("S", new String[0]).select("C", "S").toList();
            page.addDataModel("tmfSpecs", tmfSpecList);
            List blueGreenReady = this.V(domainId).out(new String[0]).hasType("backend").not(__.has("/details/deploymentConfiguration/deployOptions/bluegreen", P.eq(true))).values("id", "/details/abbreviation", "name").toList();
            page.addDataModel("blueGreenReady", blueGreenReady);
            List faultToleranceSupport = this.V(domainId).out(new String[0]).values("id", "name", "/details/abbreviation", "/features/faultTolerance").as("C", new String[0]).value("faultTolerance").union(__.has("errorCodes", P.within("not required", "no")).key().is(P.eq("errorCodes")).as("T", new String[0]), __.has("httpRetryPolicy", P.within("not required", "no")).key().is(P.eq("httpRetryPolicy")).as("T", new String[0]), __.has("customHealthProbes", P.within("not required", "no")).key().is(P.eq("customHealthProbes")).as("T", new String[0])).select("C", "T").group().by("C").by("T").toList();
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(department);
            arguments.add(domainId);
            DiagramGeneralDomainMethod diagramGeneralDomainMethod = new DiagramGeneralDomainMethod(this.diagramService);
            String encodedText = this.buildDiagramImageURL(diagramGeneralDomainMethod, arguments);
            if (encodedText != null) {
                page.addDataModel("encodedDiagramGeneralDomain", encodedText);
            }
            if ((encodedText = this.buildDiagramImageURL(diagramDomainMethod = new DiagramDomainMethod(this.diagramService), arguments)) != null) {
                page.addDataModel("encodedDiagramDomain", encodedText);
            }
            page.addDataModel("faultToleranceSupport", faultToleranceSupport);
        }
        return confluencePageList;
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

