/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.confluence.summary;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.tasks.confluence.AbstractConfluenceGenerationPageVerticle;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSummaryMicroservicesVerticle
extends AbstractConfluenceGenerationPageVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ConfluenceSummaryMicroservicesVerticle.class);
    @Resource
    protected Provider<ConfluencePage> confluencePageProvider;

    @Override
    protected List<ConfluencePage> prepareConfluencePageList(String department) {
        return null;
    }

    @Override
    protected List<ConfluencePage> prepareConfluencePageList() {
        ArrayList<ConfluencePage> confluencePageList = new ArrayList<ConfluencePage>();
        ConfluencePage page = (ConfluencePage)this.confluencePageProvider.get();
        confluencePageList.add(page);
        page.setTitle("Cloud Microservices list");
        page.setParentTitle("Summary");
        page.setType("summary");
        page.setTemplate("summary/microservicesList.ftlh");
        page.setDirectoryPath("summary/");
        page.setFileName("microservices");
        List microservicesList = this.graph.traversal().V("root").out(new String[0]).hasType("domain").as("D", new String[0]).out(new String[0]).not(__.hasType("library")).has("isMicroservice", P.eq(true)).as("C", new String[0]).local(__.in(new String[0]).where(__.not(__.hasType("domain"))).count()).as("T", new String[0]).local(__.outE("info").as("LU", new String[0]).inV().hasType("language").as("LV", new String[0]).select("LU", "LV").values("usages:/LU/usage", "id:/LV/id", "name:/LV/name", "version:/LV/version").fold()).as("L", new String[0]).select("D", "C", "T", "L").toList();
        for (Map microservice : microservicesList) {
            String framework;
            JsonObject component = (JsonObject)microservice.get("C");
            String languages = LanguageUtils.getLanguagesAsString(this.graph, component);
            if (!StringUtils.isEmpty((CharSequence)languages)) {
                microservice.put("language", languages);
            }
            if ((framework = (String)JsonPointer.from((String)"/details/framework").queryJson((Object)component)) != null && !framework.isEmpty()) {
                List<String> frameworks = Arrays.asList(framework.split("\\s*,\\s*"));
                microservice.put("framework", String.join((CharSequence)", ", TechNormalizationHelper.normalizeTechs(frameworks)));
            }
            List versions = JsonUtils.asList(microservice.get("L"));
            ArrayList<String> sources = new ArrayList<String>();
            ArrayList<String> targets = new ArrayList<String>();
            for (Object languageVersion : versions) {
                Map<String, String> versionDetails = JsonUtils.asMap(languageVersion);
                List<String> languageUsages = JsonUtils.asList(versionDetails.get("usages"));
                if (languageUsages == null) continue;
                ConfluenceSummaryMicroservicesVerticle.updateUsages(versionDetails, languageUsages, sources, "source");
                ConfluenceSummaryMicroservicesVerticle.updateUsages(versionDetails, languageUsages, targets, "target");
            }
            JsonObject versionsList = new JsonObject();
            versionsList.put("source", (Object)String.join((CharSequence)", ", sources));
            versionsList.put("target", (Object)String.join((CharSequence)", ", targets));
            microservice.remove("L");
            microservice.put("version", versionsList);
        }
        page.addDataModel("microservicesList", microservicesList);
        return confluencePageList;
    }

    private static void updateUsages(Map<String, String> languageVersion, List<String> languageUsages, List<String> usageContainer, String usage) {
        String version;
        if (languageUsages.contains(usage) && (version = languageVersion.get("version")) != null) {
            usageContainer.add(version);
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

