/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.dependency;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MavenDependencyDumpExtractVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOG = LoggerFactory.getLogger(MavenDependencyDumpExtractVerticle.class);
    public static final String DEFAULT_PATH = "output/dependencies";
    private final XPathFactory xPathfactory = XPathFactory.newInstance();
    private final XPath xpath = this.xPathfactory.newXPath();
    private WorkerExecutor executor;

    @Override
    protected String[] features() {
        return new String[]{"mavenDependency"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        int coresCount = CpuCoreSensor.availableProcessors();
        this.LOG.debug("Detected {} CPU cores, using all of them", (Object)coresCount);
        this.executor = this.vertx.createSharedWorkerExecutor("maven-dependency-extraction-worker-pool", coresCount, 60L, TimeUnit.MINUTES);
        BiFunction<Graph, JsonObject, List<JsonObject>> componentExtractor = AbstractAggregationTaskVerticle::getMavenDependencyComponents;
        List<Future> futures = this.processGraph(this::aggregateDomainData, c -> this.processDependencyTree((JsonObject)c, this.executor), componentExtractor);
        this.completeCompositeTask(futures, taskPromise);
    }

    private List<Future> processDependencyTree(JsonObject component, WorkerExecutor executor) {
        File depTreeFile = Path.of(component.getString("directoryPath"), new String[0]).resolve("target").resolve("dependency_tree.json").toFile();
        if (depTreeFile.exists()) {
            this.LOG.info("File {} already exists for component {}, no need to run maven", (Object)depTreeFile, (Object)component.getString("id"));
            return Collections.emptyList();
        }
        String pomPath = component.getString("directoryPath");
        this.LOG.debug("{}: Scheduling blocking execute of maven dependencies collection, root pom path {}", (Object)component.getString("name"), (Object)pomPath);
        Future blockingFuture = executor.executeBlocking(() -> this.processDependencies(component), false);
        return Collections.singletonList(blockingFuture);
    }

    private Callable<Void> processDependencies(JsonObject component) {
        long executionStart = System.nanoTime();
        this.createMavenDump(component);
        this.LOG.debug("{}: Dependency retrieval finished in {}", (Object)component.getString("id"), (Object)Duration.ofNanos(System.nanoTime() - executionStart).toString());
        return null;
    }

    private void createMavenDump(JsonObject component) {
        InvocationResult invocationResult;
        File pomFile = Path.of(component.getString("directoryPath"), new String[0]).resolve("pom.xml").toFile();
        if (!pomFile.exists()) {
            this.LOG.info("Pom file {} was not found", (Object)pomFile.getPath());
            return;
        }
        try {
            ArrayList<String> moduleLocations = new ArrayList<String>();
            moduleLocations.add("/project/profiles/profile/modules/*");
            moduleLocations.add("/project/modules/*");
            List<String> modules = this.extractProperties(pomFile, moduleLocations);
            for (String module : modules) {
                File modulePomFile = Path.of(component.getString("directoryPath"), new String[0]).resolve(module).resolve("pom.xml").toFile();
                ArrayList<String> artifactIdLocation = new ArrayList<String>();
                artifactIdLocation.add("/project/build/plugins/plugin/artifactId");
                List<String> artifactIds = this.extractProperties(modulePomFile, artifactIdLocation);
                if (!artifactIds.contains("frontend-maven-plugin")) continue;
                this.LOG.info("skipping entire component {} because of its module {} uses frontend-maven-plugin", (Object)component.getString("id"), (Object)module);
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Path dependencyDumpPath = Path.of(DEFAULT_PATH, new String[0]);
        File dir = dependencyDumpPath.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String compId = component.getString("id");
        File dependencyDumpFile = dependencyDumpPath.resolve(compId + "_dependency.txt").toFile();
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(pomFile);
        request.setBatchMode(true);
        ArrayList<String> goals = new ArrayList<String>();
        String mavenGoals = (String)JsonPointer.from((String)"/maven/dependency").queryJson((Object)component);
        if (mavenGoals != null) {
            for (String g : mavenGoals.split(" ")) {
                goals.add(g);
            }
        } else {
            goals.add("dependency:tree");
        }
        request.setGoals(goals);
        DefaultInvoker invoker = new DefaultInvoker();
        try (PrintWriter dependencyTreeWriter = new PrintWriter(new BufferedWriter(new FileWriter(dependencyDumpFile, JsonUtils.UTF_8)));){
            request.setOutputHandler(str -> this.writeToFile(str, dependencyTreeWriter));
            invocationResult = invoker.execute((InvocationRequest)request);
        }
        catch (Exception e) {
            this.report.exceptionThrown(component, e);
            return;
        }
        if (invocationResult.getExitCode() != 0) {
            this.report.addMessage("ERROR", component, compId + ": Dependency extraction failed with exit code " + invocationResult.getExitCode() + ". Result can be found here: " + dependencyDumpFile.getAbsolutePath());
        } else {
            this.LOG.debug("{}: Extraction finished. Result is stored in {} ", (Object)compId, (Object)dependencyDumpFile.getAbsolutePath());
        }
    }

    private void writeToFile(String line, PrintWriter dump) {
        dump.println(line);
    }

    private List<Future> aggregateDomainData(JsonObject jsonObject) {
        Future future = Future.succeededFuture();
        return Collections.singletonList(future);
    }

    private List<String> extractProperties(File file, List<String> locations) throws Exception {
        Document document = XmlParser.parseXmlFile(String.valueOf(file));
        ArrayList<String> properties = new ArrayList<String>();
        for (String location : locations) {
            NodeList props = null;
            try {
                props = (NodeList)this.xpath.compile(location).evaluate(document, XPathConstants.NODESET);
                for (int i = 0; i < props.getLength(); ++i) {
                    Element item = (Element)props.item(i);
                    properties.add(item.getTextContent());
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }
}

