/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.dependency;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDependencyDumpParseVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOG = LoggerFactory.getLogger(MavenDependencyDumpParseVerticle.class);
    private WorkerExecutor executor;
    public static final String COMPILE = "compile";
    public static final String PROVIDED = "provided";
    public static final String SYSTEM = "system";
    public static final String RUNTIME = "runtime";
    public static final String TEST = "test";
    static final String NEW_BRANCH = "\\+\\-\\s|\\\\\\-\\s";
    static final String EXISTING_BRANCH = "\\|\\s{2}";
    static final String SPACER = "\\s{3}";
    static final String TREE_LEVEL_REGEX = "((?:\\+\\-\\s|\\\\\\-\\s|\\|\\s{2}|\\s{3})+)";
    static final String ARTIFACT_TREE_MODULE_REGEX = "\\[INFO\\]\\s((\\S+:){3,4}\\S+).*";
    static final String ARTIFACT_TREE_DEPENDENCY_REGEX = "\\[INFO\\]\\s((?:\\+\\-\\s|\\\\\\-\\s|\\|\\s{2}|\\s{3})+)((\\S+:){4,5}\\S+).*";
    static final String ARTIFACT_EXTRACTION_ERROR_REGEX = "\\[ERROR\\]\\s.*";
    static final String ARTIFACT_TREE_NOT_RECOGNISED_REGEX = "\\[INFO\\]\\s((?:\\+\\-\\s|\\\\\\-\\s|\\|\\s{2}|\\s{3})+).*";
    public static final String DEFAULT_PATH = "output/dependencies";

    @Override
    protected String[] features() {
        return new String[]{"mavenDependencyParse"};
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        Integer coresCount = CpuCoreSensor.availableProcessors();
        this.LOG.debug("Detected {} CPU cores, using all of them", (Object)coresCount);
        this.executor = this.vertx.createSharedWorkerExecutor("maven-dependency-import-worker-pool", coresCount.intValue(), 60L, TimeUnit.SECONDS);
        BiFunction<Graph, JsonObject, List<JsonObject>> componentExtractor = AbstractAggregationTaskVerticle::getMavenDependencyComponents;
        List<Future> futures = this.processGraph(this::aggregateDomainData, c -> this.processDependencyTree((JsonObject)c, this.executor), componentExtractor);
        this.completeCompositeTask(futures, taskPromise);
    }

    private List<Future> aggregateDomainData(JsonObject jsonObject) {
        Future future = Future.succeededFuture();
        return Collections.singletonList(future);
    }

    private List<Future> processDependencyTree(JsonObject component, WorkerExecutor executor) {
        this.LOG.debug("{}: Scheduling blocking execution of maven dependencies import to the graph", (Object)component.getString("id"));
        Future blockingFuture = executor.executeBlocking(() -> this.processDependencies(component), false);
        return Collections.singletonList(blockingFuture);
    }

    private Callable<Void> processDependencies(JsonObject component) {
        long executionStart = System.currentTimeMillis();
        File depTreeFile = Path.of(component.getString("directoryPath"), new String[0]).resolve("target").resolve("dependency_tree.json").toFile();
        if (depTreeFile.exists()) {
            this.parseDepTreeFromCi(component, depTreeFile);
        } else {
            this.parseDepFromMaven(component);
        }
        this.LOG.debug("{}: Dependency import finished in {}ms", (Object)component.getString("id"), (Object)(System.currentTimeMillis() - executionStart));
        return null;
    }

    private void parseDepFromMaven(JsonObject component) {
        List<JsonObject> rawDependencies = this.getDependenciesFromDump(component);
        if (!rawDependencies.isEmpty()) {
            this.processDependencies(component, rawDependencies);
        }
    }

    private void processDependencies(JsonObject component, List<JsonObject> rawDependencies) {
        Integer lastLevel = 0;
        JsonObject lastDestination = component;
        LinkedList<JsonObject> stack = new LinkedList<JsonObject>();
        Graph graph = this.graph;
        String compId = component.getString("id");
        for (JsonObject destination : rawDependencies) {
            JsonObject source;
            this.generateId(destination);
            Integer targetLevel = destination.getInteger("level");
            String scope = destination.getString("scope");
            this.stripExcessiveFields(destination);
            JsonObject dependencyEdge = targetLevel.equals(1) ? new JsonObject().put("type", (Object)"module").put("component", (Object)compId) : new JsonObject().put("type", (Object)"dependency").put("scope", (Object)scope).put("component", (Object)compId);
            if (targetLevel > lastLevel) {
                source = lastDestination;
                if (targetLevel - lastLevel > 1) {
                    this.LOG.error("{}: Error during parsing the dependency tree: potentially missed entry before the line between {} and {}. Levels {}-{}", new Object[]{compId, source.getString("id"), destination.getString("id"), lastLevel, targetLevel});
                }
                stack.push(source);
            } else if (targetLevel == lastLevel) {
                source = (JsonObject)stack.peek();
            } else {
                for (int i = 0; i < lastLevel - targetLevel; ++i) {
                    stack.remove();
                }
                source = (JsonObject)stack.peek();
            }
            lastDestination = destination;
            lastLevel = targetLevel;
            graph.addEdge(source, destination, dependencyEdge);
        }
    }

    private void stripExcessiveFields(JsonObject destination) {
        destination.remove("scope");
        destination.remove("level");
    }

    private void generateId(JsonObject destination) {
        destination.put("id", (Object)new StringBuffer().append(destination.getString("groupId")).append(":").append(destination.getString("artifactId")).append(":").append(destination.getString("package")).append(":").append(destination.getString("version")).toString());
    }

    private List<JsonObject> getDependenciesFromDump(JsonObject component) {
        File pomFile = Path.of(component.getString("directoryPath"), new String[0]).resolve("pom.xml").toFile();
        if (!pomFile.exists()) {
            return Collections.emptyList();
        }
        String compId = component.getString("id");
        Path dependencyDumpFile = Path.of(DEFAULT_PATH, compId + "_dependency.txt");
        if (!dependencyDumpFile.toFile().exists()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        try (Stream<String> stream = Files.lines(dependencyDumpFile);){
            stream.forEach(str -> this.processArtifact((String)str, result, component));
        }
        catch (IOException e) {
            this.report.exceptionThrown(component, e);
            return Collections.emptyList();
        }
        List errors = result.stream().filter(o -> o.containsKey("error")).map(o -> o.getString("error").replaceAll("\\p{Cntrl}", "")).collect(Collectors.toList());
        if (errors.size() > 0) {
            this.LOG.error("{}: Dump extraction failed", (Object)compId);
            this.report.addMessage("ERROR", component, StringUtils.join(errors, (String)"\n"));
        }
        this.LOG.debug("{}: Dump extraction finished. Received {} entries", (Object)compId, (Object)result.size());
        return result.stream().filter(o -> !o.containsKey("error")).collect(Collectors.toList());
    }

    private void processArtifact(String line, List<JsonObject> result, JsonObject component) {
        if (line.matches(ARTIFACT_EXTRACTION_ERROR_REGEX)) {
            result.add(new JsonObject().put("error", (Object)line));
        }
        if (line.matches(ARTIFACT_TREE_DEPENDENCY_REGEX)) {
            String dependencyLevel = line.replaceAll(ARTIFACT_TREE_DEPENDENCY_REGEX, "$1");
            String artifactLine = line.replaceAll(ARTIFACT_TREE_DEPENDENCY_REGEX, "$2");
            String[] artifact = artifactLine.split(":");
            result.add(new JsonObject().put("id", (Object)"").put("artifactId", (Object)artifact[1]).put("groupId", (Object)artifact[0]).put("package", (Object)artifact[2]).put("version", artifact.length == 6 ? artifact[3] + ":" + artifact[4] : artifact[3]).put("scope", (Object)(artifact.length == 6 ? artifact[5] : artifact[4])).put("level", (Object)(1 + dependencyLevel.length() / 3)).put("type", (Object)"library"));
        } else if (line.matches(ARTIFACT_TREE_MODULE_REGEX)) {
            String artifactLine = line.replaceAll(ARTIFACT_TREE_MODULE_REGEX, "$1");
            String[] artifact = artifactLine.split(":");
            result.add(new JsonObject().put("id", (Object)"").put("artifactId", (Object)artifact[1]).put("groupId", (Object)artifact[0]).put("package", (Object)artifact[2]).put("version", artifact.length == 5 ? artifact[3] + ":" + artifact[4] : artifact[3]).put("scope", (Object)COMPILE).put("level", (Object)1).put("type", (Object)"library"));
        } else if (line.matches(ARTIFACT_TREE_NOT_RECOGNISED_REGEX)) {
            this.report.addMessage("ERROR", component, "Dependency tree element not recognized: " + line);
        }
    }

    private void parseDepTreeFromCi(JsonObject component, File depTreeFile) {
        try {
            JsonObject depTree = JsonUtils.readJsonFile(depTreeFile.toString());
            JsonArray modules = depTree.getJsonArray("modules");
            if (modules == null) {
                return;
            }
            String compId = component.getString("id");
            for (Object o1 : modules) {
                JsonObject module = (JsonObject)o1;
                String projectId = module.getString("id");
                JsonObject moduleEdge = new JsonObject().put("type", (Object)"module").put("component", (Object)compId);
                this.graph.addEdge(component, this.artifactIdToVertex(projectId), moduleEdge);
                JsonArray deps = module.getJsonArray("dependencies");
                if (deps == null) continue;
                for (Object o2 : deps) {
                    JsonObject depEntry = (JsonObject)o2;
                    String artifactFrom = depEntry.getString("from");
                    String artifactTo = depEntry.getString("to");
                    JsonObject dependencyEdge = new JsonObject().put("type", (Object)"dependency").put("scope", (Object)depEntry.getString("scope")).put("component", (Object)compId);
                    this.graph.addEdge(this.artifactIdToVertex(artifactFrom), this.artifactIdToVertex(artifactTo), dependencyEdge);
                }
            }
        }
        catch (Exception e) {
            this.report.exceptionThrown(component, e);
        }
    }

    private JsonObject artifactIdToVertex(String artifactId) {
        JsonObject existing = this.graph.getVertex(artifactId);
        if (existing != null) {
            return existing;
        }
        String[] parts = artifactId.split(":");
        return new JsonObject().put("id", (Object)artifactId).put("groupId", (Object)parts[0]).put("artifactId", (Object)parts[1]).put("package", (Object)parts[2]).put("version", (Object)parts[3]).put("type", (Object)"library");
    }
}

