/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.export;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.qubership.itool.tasks.FlowTask;
import org.qubership.itool.utils.FSUtils;

public abstract class AbstractExportVerticle
extends FlowTask {
    protected abstract String getExportPath();

    protected abstract void build(String var1) throws IOException;

    protected WorkerExecutor getWorkerExecutor() {
        return this.vertx.createSharedWorkerExecutor(this.getTaskAddress() + "-export-worker-pool", 1, 60L, TimeUnit.MINUTES);
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        String exportPath;
        String finalExportPath = exportPath = this.getExportPath();
        LOG.info("Scheduling blocking execution of " + this.getTaskAddress() + " process in a separate thread");
        WorkerExecutor executor = this.getWorkerExecutor();
        Future blockingFuture = Future.future(promise -> executor.executeBlocking(o -> {
            try {
                this.createFolder(finalExportPath);
                this.build(finalExportPath);
            }
            catch (IOException e) {
                promise.fail((Throwable)e);
            }
            this.taskCompleted(taskPromise);
        }, (Handler)promise));
        blockingFuture.onSuccess(r -> this.taskCompleted(taskPromise)).onFailure(r -> {
            this.report.exceptionThrown(new JsonObject().put("id", (Object)"Unexpected"), (Exception)r);
            this.taskCompleted(taskPromise);
        });
    }

    protected void createFolder(String finalExportPath) {
        String reportFolderName = FSUtils.getFolder(finalExportPath);
        File reportFolder = new File(reportFolderName);
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
    }
}

