/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.export;

import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;
import org.qubership.itool.tasks.export.AbstractExportVerticle;
import org.qubership.itool.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportCSVJavaDependenciesVerticle
extends AbstractExportVerticle {
    protected Logger LOG = LoggerFactory.getLogger(ExportCSVJavaDependenciesVerticle.class);

    @Override
    protected String[] features() {
        return new String[]{"csvJavaDependenciesExport"};
    }

    @Override
    protected String getExportPath() {
        return "output/export/java_dependencies.csv";
    }

    @Override
    protected void build(String finalExportPath) throws IOException {
        JavaDependency javaDependency;
        ArrayList<Pair> componentDirectDep = new ArrayList<Pair>();
        ArrayList<Pair> componentTransitiveDep = new ArrayList<Pair>();
        List components = this.V(new String[0]).hasType("domain").out(new String[0]).toList();
        for (Object component : components) {
            GraphTraversal<JsonObject, JsonObject> directTraversal = this.V(component.getString("id")).as("C", new String[0]).out("module").outE("dependency").has("scope", P.neq("test")).has("component", P.eq(__.select("C").id())).inV().dedup();
            componentDirectDep.add(Pair.of((Object)component, directTraversal.clone().toList()));
            List transitiveDependencies = directTraversal.clone().outE("dependency").has("scope", P.neq("test")).inV().dedup().repeat(__.outE("dependency").has("scope", P.neq("test")).has("component", P.eq(__.select("C").id())).inV().dedup()).emit().dedup().toList();
            componentTransitiveDep.add(Pair.of((Object)component, transitiveDependencies));
        }
        HashMap<String, JavaDependency> map = new HashMap<String, JavaDependency>();
        for (Pair pair : componentDirectDep) {
            List directDep = (List)pair.getRight();
            for (JsonObject dep : directDep) {
                javaDependency = map.computeIfAbsent(dep.getString("id"), key -> new JavaDependency(dep.getString("groupId"), dep.getString("artifactId"), dep.getString("version")));
                javaDependency.getDirectComponents().add((JsonObject)pair.getLeft());
            }
        }
        for (Pair pair : componentTransitiveDep) {
            List transitiveDep = (List)pair.getRight();
            for (JsonObject dep : transitiveDep) {
                javaDependency = map.computeIfAbsent(dep.getString("id"), key -> new JavaDependency(dep.getString("groupId"), dep.getString("artifactId"), dep.getString("version")));
                javaDependency.getTransitiveComponents().add((JsonObject)pair.getLeft());
            }
        }
        ArrayList collection = new ArrayList(map.values());
        Collections.sort(collection);
        StringBuilder builder = new StringBuilder();
        builder.append("groupId,artifactId,version,direct,transitive\n");
        for (JavaDependency dep : collection) {
            builder.append(dep.groupId).append(",");
            builder.append(dep.artifactId).append(",");
            builder.append(dep.version).append(",");
            this.separatedList(builder, dep.getDirectComponents());
            builder.append(",");
            this.separatedList(builder, dep.getTransitiveComponents());
            builder.append("\n");
        }
        FSUtils.createFile(finalExportPath, builder.toString());
    }

    private void separatedList(StringBuilder builder, List<JsonObject> components) {
        Collections.sort(components, Comparator.comparing(o -> o.getString("id")));
        builder.append("\"");
        for (int i = 0; i < components.size(); ++i) {
            builder.append(components.get(i).getString("id"));
            if (i == components.size() - 1) continue;
            builder.append(", ");
        }
        builder.append("\"");
    }

    @Override
    protected Logger getLogger() {
        return this.LOG;
    }

    private static class JavaDependency
    implements Comparable<JavaDependency> {
        private String groupId;
        private String artifactId;
        private String version;
        private List<JsonObject> directComponents;
        private List<JsonObject> transitiveComponents;

        public JavaDependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.directComponents = new ArrayList<JsonObject>();
            this.transitiveComponents = new ArrayList<JsonObject>();
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public List<JsonObject> getDirectComponents() {
            return this.directComponents;
        }

        public List<JsonObject> getTransitiveComponents() {
            return this.transitiveComponents;
        }

        @Override
        public int compareTo(JavaDependency o1) {
            if (this.groupId.equals(o1.groupId) && this.artifactId.equals(o1.artifactId) && this.version.equals(o1.version)) {
                return 0;
            }
            if (!this.groupId.equals(o1.groupId)) {
                return this.groupId.compareTo(o1.groupId);
            }
            if (!this.artifactId.equals(o1.artifactId)) {
                return this.artifactId.compareTo(o1.artifactId);
            }
            if (this.version != null && o1.version == null) {
                return 1;
            }
            if (this.version == null && o1.version != null) {
                return -1;
            }
            return P.lteVersion(o1.version).test(this.version) ? -1 : 1;
        }
    }
}

