/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.util.AntPathMatcher;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.tasks.FlowTask;

public abstract class AbstractInclusiveParseFileTask
extends FlowTask {
    protected static final String LINE_BREAK_REGEX = "[\\n\\r]{1,2}";
    protected static final Pattern LINE_BREAK_PATTERN = Pattern.compile("[\\n\\r]{1,2}");
    private WorkerExecutor executor;

    @Override
    protected void taskStart(Promise<?> taskPromise) throws Exception {
        Integer coresCount = CpuCoreSensor.availableProcessors();
        this.executor = this.vertx.createSharedWorkerExecutor("parsing-worker-pool", coresCount.intValue(), 10L, TimeUnit.MINUTES);
        List<Future> futures = this.parseFiles(this.executor, this.getFilePatterns());
        this.joinFuturesAndHandleResult(futures).onComplete(res -> this.taskCompleted(taskPromise));
    }

    protected abstract String[] getFilePatterns();

    protected abstract void parseSingleFile(JsonObject var1, JsonObject var2, String var3) throws IOException;

    protected List<Future> parseFiles(WorkerExecutor executor, String ... filePatterns) {
        ArrayList<String> simplePatterns = new ArrayList<String>();
        ArrayList<Pattern> shallowPatterns = new ArrayList<Pattern>();
        ArrayList<String> deepPatterns = new ArrayList<String>();
        for (String filePattern : filePatterns) {
            if (!filePattern.contains("*") && !filePattern.contains("?")) {
                simplePatterns.add(filePattern);
                continue;
            }
            if (!filePattern.contains("/")) {
                Pattern regex = Pattern.compile((filePattern.startsWith("*.") ? "^." : "^") + filePattern.replace(".", "\\.").replace("*", ".*") + (filePattern.endsWith(".*") ? ".$" : "$"));
                shallowPatterns.add(regex);
                continue;
            }
            deepPatterns.add(filePattern);
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        List<Map<String, JsonObject>> componentsWithDomains = this.getComponentsWithDomains();
        for (Map<String, JsonObject> componentWithDomain : componentsWithDomains) {
            JsonObject domain = componentWithDomain.get("D");
            JsonObject component = componentWithDomain.get("C");
            this.getLogger().debug("Queue the parsing of files for {} component", (Object)component.getString("id"));
            Future future = executor.executeBlocking(() -> {
                long startTime = System.nanoTime();
                List<String> pathList = this.findAllFiles(component, simplePatterns, shallowPatterns, deepPatterns);
                for (String fileName : pathList) {
                    try {
                        this.parseSingleFile(domain, component, fileName);
                    }
                    catch (Exception e) {
                        this.report.addMessage("EXCEPTION", component, "Parsing of file " + fileName + " failed:\n" + ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                long endTime = System.nanoTime();
                long processingTime = endTime - startTime;
                this.getLogger().debug("Processing time for component " + String.valueOf(component.getValue("id")) + ": " + String.valueOf(Duration.ofNanos(processingTime)));
                return null;
            }, false);
            futures.add(future);
        }
        return futures;
    }

    protected List<Map<String, JsonObject>> getComponentsWithDomains() {
        return this.V(new String[0]).hasType("domain").as("D", new String[0]).out(new String[0]).hasKeys("directoryPath").as("C", new String[0]).select("D", "C").toList();
    }

    protected List<String> findAllFiles(JsonObject component, List<String> simplePatterns, List<Pattern> shallowPatterns, List<String> deepPatterns) {
        ArrayList<String> result = new ArrayList<String>();
        String directoryPath = component.getString("directoryPath");
        JsonArray excludeDirs = component.getJsonArray("excludeDirs");
        Set<Path> topDirExcludes = excludeDirs == null || excludeDirs.isEmpty() ? Collections.emptySet() : excludeDirs.stream().map(s -> Path.of((String)s, new String[0])).collect(Collectors.toSet());
        for (String filePattern : simplePatterns) {
            File file;
            if (this.isExcluded(topDirExcludes, Path.of(filePattern, new String[0]), Path.of(directoryPath, new String[0])) || !(file = new File(directoryPath, filePattern)).isFile()) continue;
            result.add(file.getPath());
        }
        if (shallowPatterns.isEmpty() && deepPatterns.isEmpty()) {
            return result;
        }
        Path basePath = FileSystems.getDefault().getPath(directoryPath, new String[0]);
        PathAccumulatorVisitor visitor = new PathAccumulatorVisitor(basePath, shallowPatterns, deepPatterns, topDirExcludes);
        try {
            Files.walkFileTree(basePath, visitor);
        }
        catch (IOException | UncheckedIOException e) {
            this.report.addMessage("EXCEPTION", component, "Critical failure during file walking procedure:\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        visitor.getPaths().forEach(path -> result.add(path.toString()));
        this.getLogger().trace("{}: Found files {}", (Object)component.getString("id"), result);
        return result;
    }

    protected boolean isExcluded(Collection<Path> topDirExcludes, Path relativePath, Path fileDirectory) {
        for (Path topDirExclude : topDirExcludes) {
            if (!relativePath.startsWith(topDirExclude)) continue;
            this.getLogger().trace("Excluding file {} belonging to a subComponent directory {}", (Object)relativePath, (Object)topDirExclude);
            return true;
        }
        return false;
    }

    class PathAccumulatorVisitor<T extends Path>
    extends SimpleFileVisitor<T> {
        List<T> paths = new ArrayList<T>();
        List<Pattern> shallowPatterns;
        List<String> deepPatterns;
        Collection<Path> topDirExcludes;
        Path basePath;

        public PathAccumulatorVisitor(Path basePath, List<Pattern> shallowPatterns, List<String> deepPatterns, Collection<Path> topDirExcludes) {
            this.basePath = basePath;
            this.shallowPatterns = shallowPatterns;
            this.deepPatterns = deepPatterns;
            this.topDirExcludes = topDirExcludes;
        }

        public List<T> getPaths() {
            return this.paths;
        }

        @Override
        public FileVisitResult visitFile(T file, BasicFileAttributes attrs) throws IOException {
            super.visitFile(file, attrs);
            if (!attrs.isRegularFile()) {
                return FileVisitResult.CONTINUE;
            }
            for (Pattern regex : this.shallowPatterns) {
                if (!regex.matcher(file.getFileName().toString()).matches()) continue;
                this.paths.add(file);
                return FileVisitResult.CONTINUE;
            }
            if (this.deepPatterns.isEmpty()) {
                return FileVisitResult.CONTINUE;
            }
            Path relativePath = this.basePath.relativize((Path)file);
            String relativePathString = relativePath.toString().replace('\\', '/');
            for (String deepPattern : this.deepPatterns) {
                if (!AntPathMatcher.INSTANCE.match(deepPattern, relativePathString)) continue;
                this.paths.add(file);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(T file, IOException exc) throws IOException {
            AbstractInclusiveParseFileTask.this.report.addMessage("EXCEPTION", new JsonObject().put("id", (Object)"iTool"), "File walking failure during attempt to visit file " + file.toString() + ":\n" + ExceptionUtils.getStackTrace((Throwable)exc));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(T dir, BasicFileAttributes attrs) throws IOException {
            super.preVisitDirectory(dir, attrs);
            Path relativePath = this.basePath.relativize((Path)dir);
            if (AbstractInclusiveParseFileTask.this.isExcluded(this.topDirExcludes, relativePath, (Path)dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

