/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.qubership.itool.tasks.parsing.AbstractParseFileDataTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParseYamlFileDataTask
extends AbstractParseFileDataTask {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractParseYamlFileDataTask.class);

    @Override
    protected void processFile(JsonObject domain, JsonObject component, JsonObject file) {
        JsonArray sections = file.getJsonArray("structured");
        String filePath = file.getString("path");
        if (sections == null) {
            this.report.internalError("File " + filePath + " (" + file.getString("id") + ") contains no data or could not be parsed");
            return;
        }
        int index = 0;
        for (Object section : sections) {
            this.processYamlSection(domain, component, file, index++, section);
        }
    }

    protected void processYamlSection(JsonObject domain, JsonObject component, JsonObject file, int index, Object data) {
        if (data instanceof JsonObject) {
            this.processYamlSection(domain, component, file, index, (JsonObject)data);
        } else if (data instanceof JsonArray) {
            this.processYamlSection(domain, component, file, index, (JsonArray)data);
        } else if (data != null) {
            String fileLink = file.getString("fileLink");
            this.report.internalError("File " + fileLink + " (" + file.getString("id") + ") contains unrecognized section at index " + index);
        }
    }

    protected void processYamlSection(JsonObject domain, JsonObject component, JsonObject file, int index, JsonObject data) {
        String fileLink = file.getString("fileLink");
        this.report.internalError("File " + fileLink + " (" + file.getString("id") + ") contains Object section at index " + index + ", but task " + this.getClass().getName() + " does not support it");
    }

    protected void processYamlSection(JsonObject domain, JsonObject component, JsonObject file, int index, JsonArray data) {
        String fileLink = file.getString("fileLink");
        this.report.internalError("File " + fileLink + " (" + file.getString("id") + ") contains Array section at index " + index + ", but task " + this.getClass().getName() + " does not support it");
    }
}

