/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNestedComponentsVerticle
extends AbstractParseFileTask {
    protected static final Logger LOG = LoggerFactory.getLogger(ExtractNestedComponentsVerticle.class);

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"inventory-components.json"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject topComponent, String fileName) throws IOException {
        JsonObject inventory = JsonUtils.readJsonFile(fileName);
        JsonArray componentDescriptions = inventory.getJsonArray("components");
        if (componentDescriptions == null) {
            return;
        }
        String releaseBranch = (String)JsonPointer.from((String)"/details/releaseBranch").queryJson((Object)topComponent);
        String domainFromInventory = inventory.getString("domain");
        domainFromInventory = ConfigUtils.fillDomainId(domainFromInventory);
        Graph graph = this.graph;
        JsonObject topComponentDescriptions = this.getTopComponentDescriptions(componentDescriptions);
        if (topComponentDescriptions != null) {
            componentDescriptions.remove((Object)topComponentDescriptions);
            if (!topComponentDescriptions.getString("id").equals(topComponent.getString("id"))) {
                LOG.info("Initial top component ID ({}) didn't match the ID of the top component in inventory-componentns file, relocating it to new id {}", (Object)topComponent.getString("id"), (Object)topComponentDescriptions.getString("id"));
                graph.relocateVertex(topComponent, topComponentDescriptions.getString("id"));
            }
            this.processTopComponent(topComponent, topComponentDescriptions, domainFromInventory);
            JsonArray excludedDirs = this.getDirsToExclude(componentDescriptions);
            topComponent.put("excludeDirs", (Object)excludedDirs);
            this.getLogger().info("Following subdirectories are excluded from top component: {}", (Object)excludedDirs);
        } else {
            this.getLogger().info("Root component {} not present in directory '{}' and will be removed from the graph", (Object)topComponent.getString("id"), (Object)topComponent.getString("directoryPath"));
            graph.removeVertex(topComponent);
        }
        for (Object descriptionObject : componentDescriptions) {
            JsonObject componentDescription = (JsonObject)descriptionObject;
            String id = componentDescription.getString("id");
            String directory = ExtractNestedComponentsVerticle.getDirectory(componentDescription);
            JsonObject detailsJson = new JsonObject().put("domain", (Object)domainFromInventory).put("domainFromInventory", (Object)domainFromInventory).put("releaseBranch", (Object)releaseBranch).put("abbreviation", (Object)id);
            JsonObject newComponent = new JsonObject().put("id", (Object)id).put("type", (Object)"unknown").put("directoryPath", (Object)Path.of(topComponent.getString("directoryPath"), directory).toString()).put("repository", (Object)topComponent.getString("repository")).put("repositorySubDir", (Object)directory).put("details", (Object)detailsJson);
            JsonObject newDomain = (JsonObject)this.V(domainFromInventory).next();
            if (newDomain == null) {
                newDomain = new JsonObject().put("id", (Object)domainFromInventory).put("type", (Object)"domain").put("department", (Object)domain.getString("department", "unknown")).put("isMock", (Object)true);
                graph.addVertexUnderRoot(newDomain);
            }
            this.processNewComponent(topComponent, graph, newComponent, newDomain);
        }
    }

    private JsonArray getDirsToExclude(JsonArray componentDescriptions) {
        return new JsonArray(componentDescriptions.stream().map(o -> (JsonObject)o).map(ExtractNestedComponentsVerticle::getDirectory).collect(Collectors.toList()));
    }

    private static String getDirectory(JsonObject componentDescription) {
        return componentDescription.getString("directory", "").replaceFirst("^\\.?/*", "").replaceFirst("/+$", "");
    }

    private JsonObject getTopComponentDescriptions(JsonArray componentDescriptions) {
        for (Object o : componentDescriptions) {
            JsonObject componentDescriptor = (JsonObject)o;
            String directory = ExtractNestedComponentsVerticle.getDirectory(componentDescriptor);
            if (!directory.isEmpty()) continue;
            return componentDescriptor;
        }
        return null;
    }

    private void processNewComponent(JsonObject topComponent, Graph graph, JsonObject newComponent, JsonObject newDomain) {
        String id = newComponent.getString("id");
        if (graph.getVertex(id) == null) {
            this.getLogger().info("Adding new component placeholder ({}) to graph", (Object)newComponent.getString("id"));
            boolean isAdded = graph.addVertex(newDomain, newComponent);
            if (!isAdded) {
                this.report.addMessage("ERROR", topComponent, "Failed to add component '" + String.valueOf(newComponent) + "' from multi-component repository");
            }
        } else {
            this.report.addMessage("CONF_ERROR", newComponent, "The component with same ID is already present in multi-component repository");
        }
    }

    private void processTopComponent(JsonObject topComponent, JsonObject componentDescription, String domainFromInventory) {
        this.getLogger().info("Processing top component '{}'", (Object)topComponent.getString("id"));
        JsonObject topDetails = JsonUtils.getOrCreateJsonObject(topComponent, "details");
        topDetails.put("abbreviation", (Object)componentDescription.getString("id"));
        topDetails.put("domainFromInventory", (Object)domainFromInventory);
    }
}

