/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.qubership.itool.tasks.parsing.AbstractParseFileDataTask;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseDockerFileVerticle
extends AbstractParseFileDataTask {
    protected Logger LOGGER = LoggerFactory.getLogger(ParseDockerFileVerticle.class);

    @Override
    protected List<Map<String, JsonObject>> getTuples() {
        List<Map<String, JsonObject>> tuples = this.V(new String[0]).hasType("domain").as("D", new String[0]).out(new String[0]).as("C", new String[0]).out(new String[0]).hasType("file").has("name", "Dockerfile").as("F", new String[0]).select("D", "C", "F").toList();
        return tuples;
    }

    @Override
    protected void processFile(JsonObject domain, JsonObject component, JsonObject file) {
        BufferedReader reader = new BufferedReader(new StringReader(file.getString("content", "")));
        String from = null;
        try {
            from = this.readFrom(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (from == null) {
            return;
        }
        JsonObject details = JsonUtils.getOrCreateJsonObject(component, "details");
        details.put("dockerfile", (Object)new JsonObject().put("imageRoot", (Object)from));
    }

    private String readFrom(BufferedReader reader) throws IOException {
        String from;
        do {
            if ((from = reader.readLine()) != null) continue;
            return null;
        } while ((from = from.trim()).startsWith("#"));
        if (!from.startsWith("FROM ")) {
            return null;
        }
        return from.replace("FROM ", "");
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

