/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.json.JsonObject;
import jakarta.inject.Provider;
import java.io.IOException;
import javax.annotation.Resource;
import org.qubership.itool.modules.parsing.InventoryJsonParser;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseInventoryFileVerticle
extends AbstractParseFileTask {
    protected Logger LOGGER = LoggerFactory.getLogger(ParseInventoryFileVerticle.class);
    @Resource
    protected Provider<InventoryJsonParser> inventoryJsonParser;

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"inventory.md", "inventory.json"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        String inventorySource;
        this.getLogger().info("Parsing {} from {}", (Object)fileName, (Object)component.getString("id"));
        try {
            inventorySource = FSUtils.readFileSafe(fileName);
        }
        catch (IOException e) {
            System.out.println("Failed to read " + fileName);
            return;
        }
        if (fileName.endsWith("inventory.json")) {
            ((InventoryJsonParser)this.inventoryJsonParser.get()).parse(domain, component, inventorySource);
        }
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

