/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.configuration;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.IOException;
import org.qubership.itool.tasks.parsing.AbstractInclusiveParseFileTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseSqlFilesVerticle
extends AbstractInclusiveParseFileTask {
    protected Logger LOGGER = LoggerFactory.getLogger(ParseSqlFilesVerticle.class);
    protected final JsonPointer SQL_COUNT_POINTER = JsonPointer.from((String)"/details/sqlFilesCount");

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"**/*.sql"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        int currentSqlCount;
        JsonObject existingSqlCountJson = (JsonObject)this.SQL_COUNT_POINTER.queryJson((Object)component);
        int n = currentSqlCount = existingSqlCountJson == null ? 1 : existingSqlCountJson.getInteger("sqlCount") + 1;
        if (existingSqlCountJson == null) {
            existingSqlCountJson = new JsonObject();
        }
        existingSqlCountJson.put("sqlCount", (Object)currentSqlCount);
        this.SQL_COUNT_POINTER.writeJson((Object)component, (Object)existingSqlCountJson, true);
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

