/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.other;

import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Emphasis;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.parsing.MdParserUtils;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.FSUtils;
import org.qubership.itool.utils.GitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseErrorCodesVerticle
extends AbstractParseFileTask {
    protected Logger LOGGER = LoggerFactory.getLogger(ParseErrorCodesVerticle.class);
    private final Parser parser;

    public ParseErrorCodesVerticle() {
        List<Extension> extensions = Arrays.asList(TablesExtension.create());
        this.parser = Parser.builder().extensions(extensions).build();
    }

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"docs/**/troubleshooting-guide.md", "docs/troubleshooting/errors/*.md", "documents/troubleshooting/errors/*.md", "documents/**/troubleshooting-guide.md"};
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        if (fileName.endsWith("troubleshooting-guide.md")) {
            this.parseTroubleshootingGuide(domain, component, fileName);
        } else {
            this.parseSingleError(domain, component, fileName);
        }
    }

    private void parseTroubleshootingGuide(JsonObject domain, JsonObject component, String fileName) throws IOException {
        TableHead head;
        String data = FSUtils.readFileSafe(fileName);
        Node doc = this.parser.parse(data);
        Node pointer = doc.getFirstChild();
        while (pointer != null && (head = MdParserUtils.findTableHead(pointer)) != null) {
            TableBody body = MdParserUtils.findTableBody((Node)head);
            List<TableCell> headCells = MdParserUtils.collectCells(head.getFirstChild().getFirstChild());
            Integer errorCodeIdx = MdParserUtils.findColumnIdxByText(headCells, "Error Code");
            Integer messageIdx = MdParserUtils.findColumnIdxByText(headCells, "Error Message", "Message Text (English)", "Message Text");
            Integer scenarioIdx = MdParserUtils.findColumnIdxByText(headCells, "Scenario");
            Integer reasonIdx = MdParserUtils.findColumnIdxByText(headCells, "Reason");
            Integer solutionIdx = MdParserUtils.findColumnIdxByText(headCells, "Solution");
            if (errorCodeIdx != null && messageIdx != null) {
                List<TableRow> rows = MdParserUtils.collectRows(body.getFirstChild());
                for (TableRow row : rows) {
                    List<TableCell> cells = MdParserUtils.collectCells(row.getFirstChild());
                    List errorCodes = MdParserUtils.collectSiblings(cells.get(errorCodeIdx).getFirstChild()).stream().filter(node -> node instanceof Text).map(text -> ((Text)text).getLiteral()).collect(Collectors.toList());
                    String errorMessage = this.getContentsofCell(cells, messageIdx);
                    String scenario = null;
                    if (scenarioIdx != null) {
                        scenario = this.getContentsofCell(cells, scenarioIdx);
                    }
                    String reason = null;
                    if (reasonIdx != null) {
                        reason = this.getContentsofCell(cells, reasonIdx);
                    }
                    String solution = null;
                    if (solutionIdx != null) {
                        solution = this.getContentsofCell(cells, solutionIdx);
                    }
                    for (String code : errorCodes) {
                        this.addErrorCode(component, fileName, code, errorMessage, scenario, reason, solution);
                    }
                }
            }
            pointer = body.getParent();
        }
    }

    private String getContentsofCell(List<TableCell> cells, Integer cellIdx) {
        String content = null;
        Node cellContents = cells.get(cellIdx).getFirstChild();
        if (cellContents instanceof Text) {
            content = ((Text)cellContents).getLiteral();
        } else if (cellContents instanceof Emphasis) {
            content = ((Text)cellContents.getFirstChild()).getLiteral();
        }
        return content;
    }

    private void parseSingleError(JsonObject domain, JsonObject component, String fileName) throws IOException {
        String code = Path.of(fileName, new String[0]).getFileName().toString().replaceFirst("\\.md$", "");
        String data = FSUtils.readFileSafe(fileName);
        Node doc = this.parser.parse(data);
        String messageText = null;
        String scenarioText = null;
        String reasonText = null;
        String solutionText = null;
        Node nameHeading = MdParserUtils.findHeading(doc.getFirstChild(), 2, code);
        Node textHeading = MdParserUtils.findHeading(nameHeading, 3, "message text", MdParserUtils.LOWERCASE_EXTRACTOR);
        Node textHeadingScenario = MdParserUtils.findHeading(nameHeading, 3, "scenario", MdParserUtils.LOWERCASE_EXTRACTOR);
        Node textHeadingReason = MdParserUtils.findHeading(nameHeading, 3, "reason", MdParserUtils.LOWERCASE_EXTRACTOR);
        Node textHeadingSolution = MdParserUtils.findHeading(nameHeading, 3, "solution", MdParserUtils.LOWERCASE_EXTRACTOR);
        if (textHeading != null) {
            messageText = this.getTextOfParagraph(textHeading);
        }
        if (textHeadingScenario != null) {
            scenarioText = this.getTextOfParagraph(textHeadingScenario);
        }
        if (textHeadingReason != null) {
            reasonText = this.getTextOfParagraph(textHeadingReason);
        }
        if (textHeadingSolution != null) {
            solutionText = this.getTextOfParagraph(textHeadingSolution);
        }
        this.addErrorCode(component, fileName, code, messageText, scenarioText, reasonText, solutionText);
    }

    private String getTextOfParagraph(Node textHeading) {
        List<Paragraph> paras = MdParserUtils.collectParagraphs(textHeading.getNext());
        return paras.isEmpty() ? null : paras.stream().map(para -> ((Text)para.getFirstChild()).getLiteral()).collect(Collectors.joining("\n"));
    }

    private void addErrorCode(JsonObject component, String fileName, String code, String messageText, String scenarioText, String reasonText, String solutionText) {
        JsonObject edge;
        JsonObject errorCode;
        Graph graph;
        JsonObject details = new JsonObject().put("describedIn", (Object)GitUtils.buildRepositoryLink(component, fileName, this.config()));
        if (messageText != null) {
            details.put("messageText", (Object)messageText);
        } else {
            this.report.mandatoryValueMissed(component, "/errorCode/" + code + "/messageText");
        }
        if (scenarioText != null) {
            details.put("scenario", (Object)scenarioText);
        }
        if (reasonText != null) {
            details.put("reason", (Object)reasonText);
        }
        if (solutionText != null) {
            details.put("solution", (Object)solutionText);
        }
        if ((graph = this.graph).addEdge(component, errorCode = new JsonObject().put("id", (Object)code).put("type", (Object)"errorCode").put("name", (Object)code).put("details", (Object)details), edge = new JsonObject().put("type", (Object)"errorCode")) == null) {
            this.report.componentDuplicated(component, errorCode);
        }
    }
}

