/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.parsing.other;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.itool.tasks.parsing.AbstractParseFileTask;
import org.qubership.itool.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseSearchPasswordInYamlVerticle
extends AbstractParseFileTask {
    protected Logger LOGGER = LoggerFactory.getLogger(ParseSearchPasswordInYamlVerticle.class);
    private static Pattern pattern = Pattern.compile("^\\s*(?![#\\s])-?.*?(password(?!\\w).*?[=:]\\s*((\\$\\{\\S{3,}\\s*:\\s*\\S{3,}\\})|((?!\\$\\{.*\\})(?!.*\\{\\{.*\\}\\})\\S{3,})|(\\S\\{\\{(?!\\s*\\.Values\\.\\w+).*\\}\\})).*?)$", 2);

    @Override
    protected String[] getFilePatterns() {
        return new String[]{"*.yml", "*.yaml"};
    }

    @Override
    protected void parseSingleFile(JsonObject domain, JsonObject component, String fileName) throws IOException {
        JsonObject details = component.getJsonObject("details");
        if (details == null) {
            return;
        }
        String yamlSource = FSUtils.readFileSafe(fileName);
        if (yamlSource == null) {
            return;
        }
        JsonObject fileEntry = new JsonObject();
        JsonArray passwordsList = new JsonArray();
        if (fileName.toLowerCase(Locale.ROOT).contains("dev")) {
            fileEntry.put("profile", (Object)"dev");
        }
        fileEntry.put("passwords", (Object)passwordsList);
        for (String row : yamlSource.split("\n\r|\r\n|\r|\n")) {
            if (!this.checkPattern(row)) continue;
            passwordsList.add((Object)row);
        }
        if (!passwordsList.isEmpty()) {
            this.LOGGER.info("Plain password in YAML found for " + component.getString("id"));
            JsonObject passwordsPerFile = details.getJsonObject("passwords");
            if (null == passwordsPerFile) {
                passwordsPerFile = new JsonObject();
                details.put("passwords", (Object)passwordsPerFile);
            }
            passwordsPerFile.put(FSUtils.relativePath(component, fileName), (Object)fileEntry);
        }
    }

    public boolean checkPattern(String row) {
        Matcher matcher = pattern.matcher(row);
        return matcher.matches();
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

