/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.repository;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.SucceededFuture;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.Git;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoriesCommitResultsVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(RepositoriesCommitResultsVerticle.class);
    @Resource
    @Nullable
    private GitAdapter gitAdapter;

    @Override
    protected String[] features() {
        return new String[]{"repositoryUpdate", "unskippable"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        if (this.gitAdapter == null) {
            this.getLogger().warn("Offline mode. Exitting.");
            this.taskCompleted(taskPromise);
            return;
        }
        this.gitAdapter.openSuperrepository().compose(repo -> this.gitAdapter.gitAdd((Git)repo, ".").compose(r -> this.gitAdapter.gitStatus((Git)repo)).compose(status -> {
            Set missing = status.getMissing();
            Future commitFuture = SucceededFuture.EMPTY;
            String commitMessage = "Automatic commit on '" + ConfigUtils.getConfigValue("/git/releaseBranch", this.config()) + "' snapshot";
            if (missing.isEmpty()) {
                if (!status.isClean()) {
                    commitFuture = this.gitAdapter.gitCommit((Git)repo, commitMessage);
                }
            } else {
                commitFuture = this.gitAdapter.gitRm((Git)repo, missing).compose(r -> this.gitAdapter.gitCommit((Git)repo, commitMessage));
            }
            return commitFuture;
        })).onSuccess(r -> this.taskCompleted(taskPromise)).onFailure(r -> {
            this.report.internalError("Commit in super repository failed: " + ExceptionUtils.getStackTrace((Throwable)r));
            this.taskCompleted(taskPromise);
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

