/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.tasks.repository;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.tasks.AbstractAggregationTaskVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoriesCopyToSuperRepositoryVerticle
extends AbstractAggregationTaskVerticle {
    protected Logger LOGGER = LoggerFactory.getLogger(RepositoriesCopyToSuperRepositoryVerticle.class);

    @Override
    protected String[] features() {
        return new String[]{"repositoryUpdate", "unskippable"};
    }

    @Override
    protected void taskStart(Promise<?> taskPromise) {
        this.vertx.fileSystem().readFile(FSUtils.getConfigFilePath(this.config(), "config", "resultsToCommit.json")).map(fileContents -> new JsonObject(fileContents)).compose(jsonResult -> {
            List copiedResultsFutures = jsonResult.stream().map(entry -> {
                Path targetPath = ConfigUtils.getSuperRepoFilePath(this.config(), (String)entry.getValue());
                String targetDir = targetPath.toString();
                Future copiedResultFuture = this.vertx.fileSystem().exists(targetDir).compose(exists -> {
                    Future result = Future.succeededFuture();
                    if (exists.booleanValue()) {
                        result = this.vertx.fileSystem().deleteRecursive(targetDir, true);
                    }
                    return result;
                }).compose(rr -> Files.isRegularFile(Path.of((String)entry.getKey(), new String[0]), new LinkOption[0]) ? this.vertx.fileSystem().mkdirs(targetPath.getParent().toString()) : this.vertx.fileSystem().mkdirs(targetDir)).compose(rr -> this.vertx.fileSystem().copyRecursive(Path.of((String)entry.getKey(), new String[0]).toString(), targetDir, true));
                return copiedResultFuture;
            }).collect(Collectors.toList());
            return CompositeFuture.join(copiedResultsFutures);
        }).onSuccess(r -> {
            this.LOG.info("{} entries copied", (Object)r.size());
            this.taskCompleted(taskPromise);
        }).onFailure(r -> {
            this.report.internalError("Failed to copy data from result (" + ExceptionUtils.getStackTrace((Throwable)r) + ")");
            this.taskCompleted(taskPromise);
        });
    }

    @Override
    protected Logger getLogger() {
        return this.LOGGER;
    }
}

